<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="custom-header" rel="home">
		<img src="<?php echo esc_url(get_header_image()); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'title' )); ?>">
	</a>	
<?php endif;  ?>
<?php 
	$hide_show_social_icon 		= get_theme_mod( 'hide_show_social_icon','1'); 
		
?>
<header class="main-header transparent">
	<!--===// Start: Header Above
	=================================-->
	<?php if (class_exists('Clever_Fox_Setup')) { ?>
	<div class="topbar">
            <div class="container">
				<div class="row align-items-center">
					<div class="col-lg-3">
						<div class="header-top-right">
							<?php if($hide_show_social_icon =='1'):	?>
								<aside class="widget widget_social_widget">
									<?php do_action('nexcraft_abv_hdr_social'); ?>
								</aside>
							<?php endif; ?>
						</div>
					</div>
					<div class="col-lg-9">
						<?php
							$hide_show_mbl_details 		= get_theme_mod( 'hide_show_mbl_details','1'); 
							$tlh_mobile_icon 			= get_theme_mod( 'tlh_mobile_icon','fas fa-phone-alt');
							$tlh_mobile_number 			= get_theme_mod( 'tlh_mobile_number'); 
							
							$hide_show_email_details 	= get_theme_mod( 'hide_show_email_details','1');
							$tlh_email_icon 			= get_theme_mod( 'tlh_email_icon','fas fa-envelope');			
							$tlh_email 					= get_theme_mod( 'tlh_email');
							
							$hide_show_office_hours_details = get_theme_mod( 'hide_show_office_hours_details','1'); 
							$tlh_office_hours_icon 		= get_theme_mod( 'tlh_office_hours_icon','fa-clock');
							$tlh_office_hours 			= get_theme_mod( 'tlh_office_hours');
							
							if($hide_show_office_hours_details =='1' || $hide_show_email_details =='1' || $hide_show_mbl_details =='1'):
							?>
							<div class="header-widget">
								<?php if($hide_show_mbl_details =='1' && !empty($tlh_mobile_number)): ?>
									<aside class="widget widget-contact">
										<div class="contact-area">
											<div class="contact-icon">
												<i class="fas <?php echo esc_attr($tlh_mobile_icon); ?>"></i>
											</div>
											<div class="contact-info">
												<p class="text">
													<a href="tel:<?php echo esc_attr(str_replace(' ','',$tlh_mobile_number)); ?>">
														<?php echo esc_html($tlh_mobile_number); ?>
													</a>
												</p>
											</div>
										</div>
									</aside>
								<?php endif; ?>
																		
								<?php if($hide_show_email_details =='1' && !empty($tlh_email)): ?>
									<aside class="widget widget-contact">
										<div class="contact-area">
											<div class="contact-icon">
												<i class="fa <?php echo esc_attr($tlh_email_icon); ?>"></i>
											</div>
											<div class="contact-info">
												<p class="text">
													<a href="mailto:<?php echo esc_attr($tlh_email); ?>"><?php echo esc_html($tlh_email); ?></a>
												</p>
											</div>
										</div>
									</aside>
								<?php endif; ?>
								
								<?php if($hide_show_office_hours_details =='1' && !empty($tlh_office_hours)): ?>									
									<aside class="widget widget-contact">
										<div class="contact-area">
											<div class="contact-icon">
												<i class="fa <?php echo esc_attr($tlh_office_hours_icon); ?>"></i>
											</div>
											<div class="contact-info">
												<p class="text">
													<a href="javascript:void(0);"><?php echo esc_html($tlh_office_hours); ?></a>
												</p>
											</div>
										</div>
									</aside>
								<?php endif; ?>
							</div>
						<?php endif; ?>
					</div>
				</div>
            </div>
        </div>
	<?php } ?>
	<!--===// End: Header Top
=================================-->

	<!--===// Start: Navigation
=================================-->
<div class="nav-area <?php echo esc_attr(nexcraft_sticky_menu()); ?>">
            <div class="container">
                <div class="nav-area-inner">
					<div class="row align-items-center nav-h">
						<div class="col-lg-3 col-md-auto col-sm-auto col-auto">
							<?php do_action('nexcraft_logo_content'); ?>
                        </div>
                        
                        <div class="col-lg-9 col-md-auto col-sm-auto col-auto">
							
							<nav class="navbar navbar-expand-lg">
								<button class="btn-bars d-lg-none" type="button" data-bs-toggle="offcanvas"
								data-bs-target="#offcanvasExample" aria-controls="offcanvasExample" aria-label="button toggle" id="offcanvasExampleLabel">
									<i class="fas fa-bars"></i>
								</button>
								<div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasExample" aria-labelledby="offcanvasExampleLabel">
									<div class="offcanvas-header">
										<?php do_action('nexcraft_logo_content'); ?>
										<button type="button" class="btn-close" data-bs-dismiss="offcanvas"
										aria-label="Close"></button>
									</div>
									<div class="offcanvas-body">
										<?php do_action('nexcraft_primary_navigation');	?>
									</div>
								</div>
								<div class="menu-right">
									<ul>
										<li>
											<?php 
												$hide_show_search 	= get_theme_mod( 'hide_show_search','1'); 
												if($hide_show_search=='1'):	
											?>
												<a href="#" aria-label="search" data-bs-toggle="modal" data-bs-target="#GFG">
													<i class="fas fa-search"></i>
												</a>
											<?php endif; ?>
											
											<div class="modal fade" id="GFG">
												<div class="modal-dialog modal-fullscreen">
													<div class="modal-content">
														<div class="modal-header">
															<button type="button" class="btn-close" data-bs-dismiss="modal">
															</button>
														</div>
														
														<?php 
															$hide_show_search 	= get_theme_mod( 'hide_show_search','1'); 
															if($hide_show_search=='1'):	
														?>
															<div class="modal-body">
																<div class="header-search-flex">
																	<form method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>" aria-label="<?php echo esc_attr( 'Site Search', 'nexcraft' ); ?>">
																		<input type="search" class="form-control header-search-field" name="s" id="search" placeholder="<?php echo esc_attr( 'Type To Search', 'NexCraft' ); ?>"><button type="submit" class="search-submit"><i class="fa fa-search"></i></button>
																	</form>
																</div>
															</div>
														<?php endif; ?>
													</div>
												</div>
											</div>
										</li>
										<?php 
											$hide_show_cart 	= get_theme_mod( 'hide_show_cart','1'); 
											if($hide_show_cart=='1'):	
										?>
											<li class="cart_dropdown dropdown">
												<?php do_action('nexcraft_navigation_cart'); ?>
											</li>
										<?php endif; ?>
										
										<?php 
								
											$hide_show_appointment_details 		= get_theme_mod( 'hide_show_appointment_details','1'); 
											$tlh_appointment_btn_lbl 			= get_theme_mod( 'tlh_appointment_btn_lbl');
											$tlh_appointment_link 				= get_theme_mod( 'tlh_appointment_link','#');
											if($hide_show_appointment_details=='1'){
											
										?>
											<li class="header_btn">
												<?php if(!empty($tlh_appointment_btn_lbl)){ ?>
													<a href="<?php echo esc_url($tlh_appointment_link); ?>" aria-label="header btn" class="main-btn">
														<?php echo esc_html($tlh_appointment_btn_lbl); ?> <i class="fas fa-angle-double-right"></i>
													</a>
												<?php } ?>	
											</li>
										<?php } ?>
									</ul>
								</div>
							</nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>

<!--===// End: Navigation
=================================-->


</header>

<?php 
if ( !is_page_template( 'templates/template-homepage.php' )) {
		nexcraft_breadcrumbs_style();  
	}