<?php
/**
 * NexCraft Theme Customizer.
 *
 * @package NexCraft
 */

 if ( ! class_exists( 'NexCraft_Customizer' ) ) {

	/**
	 * Customizer Loader
	 *
	 * @since 1.0.0
	 */
	class NexCraft_Customizer {

		/**
		 * Instance
		 *
		 * @access private
		 * @var object
		 */
		private static $instance;

		/**
		 * Initiator
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self;
			}
			return self::$instance;
		}

		/**
		 * Constructor
		 */
		public function __construct() {
			/**
			 * Customizer
			 */
			add_action( 'customize_preview_init',                  array( $this, 'nexcraft_customize_preview_js' ) );
			add_action( 'customize_controls_enqueue_scripts', 	   array( $this, 'nexcraft_customizer_script' ) );
			add_action( 'after_setup_theme',                       array( $this, 'nexcraft_customizer_settings' ) );
			add_action( 'customize_register',                      array( $this, 'nexcraft_customizer_register' ) );
		}
		
		/**
		 * Add postMessage support for site title and description for the Theme Customizer.
		 *
		 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
		 */
		function nexcraft_customizer_register( $wp_customize ) {
			
			$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
			// $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
			$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
			$wp_customize->get_setting( 'background_color' )->transport = 'postMessage';
			$wp_customize->get_setting('custom_logo')->transport = 'refresh';

			/**
			 * Helper files
			 */
			require NEX_CRAFT_PARENT_INC_DIR . '/custom-controls/font-control.php';
			require NEX_CRAFT_PARENT_INC_DIR . '/custom-controls/range-validator/range-control.php';
			require NEX_CRAFT_PARENT_INC_DIR . '/sanitization.php';
		}

		/**
		 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
		 */
		function nexcraft_customize_preview_js() {
			wp_enqueue_script( 'nexcraft-customizer', NEX_CRAFT_PARENT_URI . '/assets/js/customizer-preview.js', array( 'customize-preview' ), '20151215', true );
		}
		
		function nexcraft_customizer_script() {
			 wp_enqueue_script( 'nexcraft-customizer-section', NEX_CRAFT_PARENT_URI .'/assets/js/customizer-section.js', array("jquery"),'', true  );	
		}

		// Include customizer customizer settings.
			
		function nexcraft_customizer_settings() {
			require NEX_CRAFT_PARENT_INC_DIR . '/customizer/nexcraft-header.php';
			require NEX_CRAFT_PARENT_INC_DIR . '/customizer/nexcraft-blog.php';
			require NEX_CRAFT_PARENT_INC_DIR . '/customizer/nexcraft-footer.php';
			require NEX_CRAFT_PARENT_INC_DIR . '/customizer/nexcraft-general.php';
			require NEX_CRAFT_PARENT_INC_DIR . '/customizer/customizer_recommended_plugin.php';
			require NEX_CRAFT_PARENT_INC_DIR . '/customizer/customizer_import_data.php';
			require NEX_CRAFT_PARENT_INC_DIR . '/customizer/nexcraft-radio-image.php';
			require NEX_CRAFT_PARENT_INC_DIR . '/customizer/nexcraft-premium.php';
		}

	}
}// End if().

/**
 *  Kicking this off by calling 'get_instance()' method
 */
NexCraft_Customizer::get_instance();