<?php
function nexcraft_general_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'nexcraft_general', array(
			'priority' => 31,
			'title' => esc_html__( 'General', 'nexcraft' ),
		)
	);
	
	
	/*=========================================
	Scroller
	=========================================*/
	$wp_customize->add_section(
		'top_scroller', array(
			'title' => esc_html__( 'Scroller', 'nexcraft' ),
			'priority' => 4,
			'panel' => 'nexcraft_general',
		)
	);
	
	$wp_customize->add_setting( 
		'hs_scroller' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'nexcraft_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 1,
		) 
	);
	
	$wp_customize->add_control(
	'hs_scroller', 
		array(
			'label'	      => esc_html__( 'Hide / Show Scroller', 'nexcraft' ),
			'section'     => 'top_scroller',
			'type'        => 'checkbox'
		) 
	);
	
	/*=========================================
	Breadcrumb  Section
	=========================================*/
	$wp_customize->add_section(
		'breadcrumb_setting', array(
			'title' => esc_html__( 'Breadcrumb', 'nexcraft' ),
			'priority' => 12,
			'panel' => 'nexcraft_general',
		)
	);
	
	// Settings
	$wp_customize->add_setting(
		'breadcrumb_settings'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	'breadcrumb_settings',
		array(
			'type' => 'hidden',
			'label' => __('Settings','nexcraft'),
			'section' => 'breadcrumb_setting',
		)
	);
	
	// Breadcrumb Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'hs_breadcrumb' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'nexcraft_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'hs_breadcrumb', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'nexcraft' ),
			'section'     => 'breadcrumb_setting',
			'type'        => 'checkbox'
		) 
	);
	
	
	
		
	// Background // 
	$wp_customize->add_setting(
		'breadcrumb_bg_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_text',
			'priority' => 9,
		)
	);

	$wp_customize->add_control(
	'breadcrumb_bg_head',
		array(
			'type' => 'hidden',
			'label' => __('Background','nexcraft'),
			'section' => 'breadcrumb_setting',
		)
	);
	
	// Background Image // 
    $wp_customize->add_setting( 
    	'breadcrumb_bg_img' , 
    	array(
			'default' 			=> esc_url(get_template_directory_uri() .'/assets/images/breadcrumb.jpg'),
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_url',	
			'priority' => 10,
		) 
	);
	
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize , 'breadcrumb_bg_img' ,
		array(
			'label'          => esc_html__( 'Background Image', 'nexcraft'),
			'section'        => 'breadcrumb_setting',
		) 
	));
	
	// Background Attachment // 
	// $wp_customize->add_setting( 
		// 'breadcrumb_back_attach' , 
			// array(
			// 'default' => 'scroll',
			// 'capability'     => 'edit_theme_options',
			// 'sanitize_callback' => 'nexcraft_sanitize_select',
			// 'priority'  => 10,
		// ) 
	// );
	
	// $wp_customize->add_control(
	// 'breadcrumb_back_attach' , 
		// array(
			// 'label'          => __( 'Background Attachment', 'nexcraft' ),
			// 'section'        => 'breadcrumb_setting',
			// 'type'           => 'select',
			// 'choices'        => 
			// array(
				// 'inherit' => __( 'Inherit', 'nexcraft' ),
				// 'scroll' => __( 'Scroll', 'nexcraft' ),
				// 'fixed'   => __( 'Fixed', 'nexcraft' )
			// ) 
		// ) 
	// );
	
	
	$wp_customize->add_setting(
	'breadcrumb_overlay_color', 
	array(
		'default' => '#151A20',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
		'priority'  => 12,
    ));
	
	$wp_customize->add_control( 
		new WP_Customize_Color_Control
		($wp_customize, 
			'breadcrumb_overlay_color', 
			array(
				'label'      => __( 'Overlay Color', 'nexcraft'),
				'section'    => 'breadcrumb_setting',
			) 
		) 
	);
	
	// Image Opacity // 
	if ( class_exists( 'NexCraft_Customizer_Range_Control' ) ) {
		$wp_customize->add_setting(
			'breadcrumb_bg_img_opacity',
			array(
				'default'			=> '6',
				'capability'     	=> 'edit_theme_options',
				'sanitize_callback' => 'nexcraft_sanitize_range_value',
				'priority'  => 11,
			)
		);
		$wp_customize->add_control( 
		new NexCraft_Customizer_Range_Control( $wp_customize, 'breadcrumb_bg_img_opacity', 
			array(
				'label'      => __( 'Opacity', 'nexcraft'),
				'section'  => 'breadcrumb_setting',
				'settings' => 'breadcrumb_bg_img_opacity',
				'input_attrs'    => array(
						'min'           => 0,
						'max'           => 100,
						'step'          => 1,
					),
			) ) 
		);
	}
	
	
	/*=========================================
	NexCraft Container
	=========================================*/
	$wp_customize->add_section(
        'nexcraft_container',
        array(
        	'priority'      => 2,
            'title' 		=> __('Container','nexcraft'),
			'panel'  		=> 'nexcraft_general',
		)
    );
	
	if ( class_exists( 'Cleverfox_Customizer_Range_Slider_Control' ) ) {
		//container width
		$wp_customize->add_setting(
			'nexcraft_site_cntnr_width',
			array(
				'default'			=> '1320',
				'capability'     	=> 'edit_theme_options',
				'sanitize_callback' => 'nexcraft_sanitize_range_value',
				'transport'         => 'postMessage',
				'priority'      => 1,
			)
		);
		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'nexcraft_site_cntnr_width', 
			array(
				'label'      => __( 'Container Width', 'nexcraft' ),
				'section'  => 'nexcraft_container',
				'input_attrs' => array(
					 'min'           => 768,
					'max'           => 2000,
					'step'          => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		
	}
	
	
	// Typography
	$wp_customize->add_setting(
		'breadcrumb_typography'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_pro_sanitize_text',
			'priority'  => 13,
		)
	);

	$wp_customize->add_control(
	'breadcrumb_typography',
		array(
			'type' => 'hidden',
			'label' => __('Typography','nexcraft'),
			'section' => 'breadcrumb_setting',
		)
	);
	
	if ( class_exists( 'NexCraft_Customizer_Range_Control' ) ) {
	// Title size // 
	$wp_customize->add_setting(
    	'breadcrumb_title_size',
    	array(
			'default' => 34,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_range_value',
			'transport'         => 'postMessage',
			'priority'  => 14,
		)
	);
	$wp_customize->add_control( 
	new NexCraft_Customizer_Range_Control( $wp_customize, 'breadcrumb_title_size', 
		array(
			'label'      => __( 'Title Size', 'nexcraft' ),
			'section'  => 'breadcrumb_setting',
			'input_attrs'    => array(				
					'min'           => 0,
					'max'           => 100,
					'step'          => 1,
				
			),
		) ) 
	);
	// Content size // 
	$wp_customize->add_setting(
    	'breadcrumb_content_size',
    	array(
			'default' => 16,			
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_range_value',
			'transport'         => 'postMessage',
			'priority'  => 15,
		)
	);
	$wp_customize->add_control( 
	new NexCraft_Customizer_Range_Control( $wp_customize, 'breadcrumb_content_size', 
		array(
			'label'      => __( 'Content Size', 'nexcraft' ),
			'section'  => 'breadcrumb_setting',
			'input_attrs'    => array(				
					'min'           => 0,
					'max'           => 50,
					'step'          => 1,
			),
		) ) 
	);
	}
	
	/*=========================================
	Nexcraft Sidebar
	=========================================*/
	$wp_customize->add_section(
        'nexcraft_sidebar',
        array(
        	'priority'      => 8,
            'title' 		=> __('Sidebar','nexcraft'),
			'panel'  		=> 'nexcraft_general',
		)
    );
	
	//  Pages Layout // 
	$wp_customize->add_setting(
		'nexcraft_pages_sidebar'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	'nexcraft_pages_sidebar',
		array(
			'type' => 'hidden',
			'label' => __('Sidebar Layout','nexcraft'),
			'section' => 'nexcraft_sidebar',
		)
	);
	
	// Default Page
	$wp_customize->add_setting( 
		'nexcraft_default_pg_sidebar' , 
			array(
			'default' => 'right_sidebar',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_select',
			'priority' => 2,
		) 
	);

	$wp_customize->add_control(
	'nexcraft_default_pg_sidebar' , 
		array(
			'label'          => __( 'Default Page Sidebar Option', 'nexcraft' ),
			'section'        => 'nexcraft_sidebar',
			'type'           => 'select',
			'choices'        => 
			array(
				'left_sidebar' 	=> __( 'Left Sidebar', 'nexcraft' ),
				'right_sidebar' 	=> __( 'Right Sidebar', 'nexcraft' ),
				'no_sidebar' 	=> __( 'No Sidebar', 'nexcraft' ),
			) 
		) 
	);
	
	// Archive Page
	$wp_customize->add_setting( 
		'nexcraft_archive_pg_sidebar' , 
			array(
			'default' => 'right_sidebar',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_select',
			'priority' => 3,
		) 
	);

	$wp_customize->add_control(
	'nexcraft_archive_pg_sidebar' , 
		array(
			'label'          => __( 'Archive Page Sidebar Option', 'nexcraft' ),
			'section'        => 'nexcraft_sidebar',
			'type'           => 'select',
			'choices'        => 
			array(
				'left_sidebar' 	=> __( 'Left Sidebar', 'nexcraft' ),
				'right_sidebar' => __( 'Right Sidebar', 'nexcraft' ),
				'no_sidebar' 	=> __( 'No Sidebar', 'nexcraft' ),
			) 
		) 
	);
	
	
	// Single Page
	$wp_customize->add_setting( 
		'nexcraft_single_pg_sidebar' , 
			array(
			'default' => 'right_sidebar',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_select',
			'priority' => 4,
		) 
	);

	$wp_customize->add_control(
	'nexcraft_single_pg_sidebar' , 
		array(
			'label'          => __( 'Single Page Sidebar Option', 'nexcraft' ),
			'section'        => 'nexcraft_sidebar',
			'type'           => 'select',
			'choices'        => 
			array(
				'left_sidebar' 	=> __( 'Left Sidebar', 'nexcraft' ),
				'right_sidebar' => __( 'Right Sidebar', 'nexcraft' ),
				'no_sidebar' 	=> __( 'No Sidebar', 'nexcraft' ),
			) 
		) 
	);
	
	
	// Blog Page
	$wp_customize->add_setting( 
		'nexcraft_blog_pg_sidebar' , 
			array(
			'default' => 'right_sidebar',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_select',
			'priority' => 5,
		) 
	);

	$wp_customize->add_control(
	'nexcraft_blog_pg_sidebar' , 
		array(
			'label'          => __( 'Blog Page Sidebar Option', 'nexcraft' ),
			'section'        => 'nexcraft_sidebar',
			'type'           => 'select',
			'choices'        => 
			array(
				'left_sidebar' 	=> __( 'Left Sidebar', 'nexcraft' ),
				'right_sidebar' => __( 'Right Sidebar', 'nexcraft' ),
				'no_sidebar' 	=> __( 'No Sidebar', 'nexcraft' ),
			) 
		) 
	);
	
	// Search Page
	$wp_customize->add_setting( 
		'nexcraft_search_pg_sidebar' , 
			array(
			'default' => 'right_sidebar',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_select',
			'priority' => 5,
		) 
	);

	$wp_customize->add_control(
	'nexcraft_search_pg_sidebar' , 
		array(
			'label'          => __( 'Search Page Sidebar Option', 'nexcraft' ),
			'section'        => 'nexcraft_sidebar',
			'type'           => 'select',
			'choices'        => 
			array(
				'left_sidebar' 	=> __( 'Left Sidebar', 'nexcraft' ),
				'right_sidebar' => __( 'Right Sidebar', 'nexcraft' ),
				'no_sidebar' 	=> __( 'No Sidebar', 'nexcraft' ),
			) 
		) 
	);
	
	
	// WooCommerce Page
	$wp_customize->add_setting( 
		'nexcraft_shop_pg_sidebar' , 
			array(
			'default' => 'right_sidebar',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_select',
			'priority' => 6,
		) 
	);

	$wp_customize->add_control(
	'nexcraft_shop_pg_sidebar' , 
		array(
			'label'          => __( 'WooCommerce Page Sidebar Option', 'nexcraft' ),
			'section'        => 'nexcraft_sidebar',
			'type'           => 'select',
			'choices'        => 
			array(
				'left_sidebar' 	=> __( 'Left Sidebar', 'nexcraft' ),
				'right_sidebar' => __( 'Right Sidebar', 'nexcraft' ),
				'no_sidebar' 	=> __( 'No Sidebar', 'nexcraft' ),
			) 
		) 
	);
	
	// Pro Upgrade
	class  NexCraft_sidebar__section_upgrade extends WP_Customize_Control {
		public function render_content() { 
			$theme = wp_get_theme(); // gets the current theme	
			
		?>
			<a class="customizer_sidebar_upgrade_section up-to-pro" style="padding:9px 0; text-align:center;" href="https://www.nayrathemes.com/nexcraft-pro/" target="_blank"><?php esc_html_e('Upgrade To Pro For More Features','nexcraft'); ?></a>
			
		<?php }
	}
	
	$wp_customize->add_setting( 'sidebar_upgrade_to_pro', array(
		'capability'			=> 'edit_theme_options',
		'nexcraft_sanitize_callback'	=> 'wp_filter_nohtml_kses',
		'priority' => 5,
	));
	$wp_customize->add_control(
		new  NexCraft_sidebar__section_upgrade(
		$wp_customize,
		'sidebar_upgrade_to_pro',
			array(
				'section'				=> 'nexcraft_sidebar',
			)
		)
	);
	
	
	// Widget options
	$wp_customize->add_setting(
		'sidebar_options'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_text',
			'priority'  => 6
		)
	);

	$wp_customize->add_control(
	'sidebar_options',
		array(
			'type' => 'hidden',
			'label' => __('Options','nexcraft'),
			'section' => 'nexcraft_sidebar',
		)
	);
	// Sidebar Width 
	if ( class_exists( 'NexCraft_Customizer_Range_Control' ) ) {
		$wp_customize->add_setting(
			'nexcraft_sidebar_width',
			array(
				'default'	      => esc_html__( '33', 'nexcraft' ),
				'capability'     	=> 'edit_theme_options',
				'sanitize_callback' => 'nexcraft_sanitize_range_value',
				'transport'         => 'postMessage',
				'priority'  => 7
			)
		);
		$wp_customize->add_control( 
		new NexCraft_Customizer_Range_Control( $wp_customize, 'nexcraft_sidebar_width', 
			array(
				'label'      => __( 'Sidebar Width', 'nexcraft' ),
				'section'  => 'nexcraft_sidebar',
				'input_attrs'    => array(
						'min'           => 25,
						'max'           => 50,
						'step'          => 1,
					),
				),
			 ) 
		);
	}
	
	// Widget Typography
	$wp_customize->add_setting(
		'sidebar_typography'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'nexcraft_sanitize_text',
		)
	);

	$wp_customize->add_control(
	'sidebar_typography',
		array(
			'type' => 'hidden',
			'label' => __('Typography','nexcraft'),
			'section' => 'nexcraft_sidebar',
			'priority'  => 21,
		)
	);
	
	// Widget Title // 
	if ( class_exists( 'NexCraft_Customizer_Range_Control' ) ) {
		$wp_customize->add_setting(
			'nexcraft_widget_ttl_size',
			array(
				'default' => 22,
				'capability'     	=> 'edit_theme_options',
				'sanitize_callback' => 'nexcraft_sanitize_range_value',
				'transport'         => 'postMessage'
			)
		);
		$wp_customize->add_control( 
		new NexCraft_Customizer_Range_Control( $wp_customize, 'nexcraft_widget_ttl_size', 
			array(
				'label'      => __( 'Widget Title Font Size', 'nexcraft' ),
				'section'  => 'nexcraft_sidebar',
				'priority'  => 22,
                'input_attrs'    => array(
					'min'           => 5,
					'max'           => 100,
					'step'          => 1                   
                ),
			) ) 
		);
	}
}

add_action( 'customize_register', 'nexcraft_general_setting' );
