<?php
/**
	nexcraft Range
 */
  if ( ! class_exists( 'WP_Customize_Control' ) ) {
	return;
}
	class NexCraft_Customizer_Range_Control extends WP_Customize_Control {

		public $type = 'nexcraft-range-slider';

		public function to_json() {
			if ( ! empty( $this->setting->default ) ) {
				$this->json['default'] = $this->setting->default;
			} else {
				$this->json['default'] = false;
			}
			parent::to_json();
		}

		public function enqueue() {
			wp_enqueue_script( 'nexcraft-range-slider', NEX_CRAFT_PARENT_INC_URI . '/custom-controls/range-validator/assets/js/range-control.js', array( 'jquery' ), '0.0', true );
			wp_enqueue_style( 'nexcraft-range-slider', NEX_CRAFT_PARENT_INC_URI . '/custom-controls/range-validator/assets/css/range-control.css','','0.0' );
		}

		public function render_content() {
		?>
			<label>
				<?php if ( ! empty( $this->label ) ) : ?>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<?php endif;
				if ( ! empty( $this->description ) ) : ?>
					<span class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
				<?php endif; ?>
				<div id="<?php echo esc_attr( $this->id ); ?>">
					<div class="nexcraft-range-slider">
						<input class="nexcraft-range-slider-range" type="range" value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->input_attrs(); $this->link(); ?> />
						<input class="nexcraft-range-slider-value" type="number" value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->input_attrs(); $this->link(); ?> />
						<?php if ( ! empty( $this->setting->default ) ) : ?>
							<span class="nexcraft-range-reset-slider" title="<?php esc_attr_e( 'Reset', 'nexcraft' ); ?>"><span class="dashicons dashicons-image-rotate"></span></span>
						<?php endif;?>
					</div>
				</div>
			</label>
		<?php }

	}
