<?php 
	$hs_above_footer			= get_theme_mod('hs_above_footer', '1');
	$footer_bg_img				= get_theme_mod('footer_bg_img', get_template_directory_uri() .'/assets/images/footer-bg.jpg');
	
	$footer_mastercard_link		= get_theme_mod('footer_mastercard_link', '#');
	$footer_visa_link		= get_theme_mod('footer_visa_link', '#');
	$footer_paypal_link	= get_theme_mod('footer_paypal_link', '#');
	$footer_amex_link		= get_theme_mod('footer_amex_link', '#');
	$footer_jcb_link		= get_theme_mod('footer_jcb_link', '#');
?>

<!-- footer section -->
<footer id="footer-section" class="footer-section" style="background-image: url(<?php echo esc_url($footer_bg_img); ?>)"> 
		<svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" preserveAspectRatio="xMidYMid slice" style="position: absolute;inset:0;z-index:-2">
            <filter id="effect2" filterUnits="userSpaceOnUse" x="0" y="0" width="100%" height="100%">
              <feImage href="<?php echo esc_url($footer_bg_img); ?>" preserveAspectRatio="xMidYMid slice" result="back"/>
              <feGaussianBlur stdDeviation="40" in="SourceGraphic"/>
              <feComponentTransfer result="cutoff">
                <feFuncA type="linear" slope="19" intercept="-9"/>
              </feComponentTransfer>
              <feComposite operator="in" in="back" in2="blur"/>
              <feGaussianBlur stdDeviation="30" result="blur"/>
            </filter>
            <image id="scene" href="<?php echo esc_url($footer_bg_img); ?>" width="100%" height="100%" preserveAspectRatio="xMidYMid slice" />
            <g id="footer-effect" style="filter:url(#effect2);fill:white">
            </g>
         </svg>
    <div class="footer_top">
		<div class="container">
			<div class="row align-items-center">
			
				<?php 		
					$footer_top_contact_icon 			= get_theme_mod( 'footer_top_contact_icon','fa-hand-point-right');
					$footer_top_contact_title 			= get_theme_mod( 'footer_top_contact_title'); 
					
					$footer_get_in_touch_icon 			= get_theme_mod( 'footer_get_in_touch_icon','fa-phone');
					$footer_get_in_touch_title 			= get_theme_mod( 'footer_get_in_touch_title'); 
					$footer_get_in_touch_number 		= get_theme_mod( 'footer_get_in_touch_number'); 		
					
					$footer_email_icon 					= get_theme_mod( 'footer_email_icon','fa-envelope'); 
					$footer_email_title 				= get_theme_mod( 'footer_email_title'); 
					$footer_email 						= get_theme_mod( 'footer_email');
					
					$footer_contct_icon 				= get_theme_mod( 'footer_contct_icon','fa-location-arrow');
					$footer_address_title 				= get_theme_mod( 'footer_address_title'); 
					$footer_contact_address 			= get_theme_mod( 'footer_contact_address');
					

					if(($hs_above_footer=='1')):
				?>
				<?php if(!empty($footer_top_contact_title)): ?>
					<div class="col-lg-3 col-sm-6">
						<h2 class="footer_top-heading"><?php echo esc_html($footer_top_contact_title); ?> <i class="far <?php echo esc_attr($footer_top_contact_icon); ?>"></i></h2>
					</div>
				<?php endif; ?>
					<?php if(!empty($footer_get_in_touch_number) || !empty($footer_get_in_touch_title)): ?>	
						<div class="col-lg-3 col-sm-6">
							<aside class="widget widget-contact">
								<div class="contact-area">
									<div class="contact-icon">
										<i class="fas <?php echo esc_attr($footer_get_in_touch_icon); ?>"></i>
									</div>
									<div class="contact-info">
										<p class="text">
											<span><?php echo esc_html($footer_get_in_touch_title); ?></span>
											<a href="tel:<?php echo esc_attr(str_replace(' ','',$footer_get_in_touch_number)); ?>">
												<?php echo esc_html($footer_get_in_touch_number); ?>
											</a>
										</p>
									</div>
								</div>
							</aside>
						</div>
					<?php endif; ?>
					
					<?php if(!empty($footer_email) || !empty($footer_email_title)): ?>	
						<div class="col-lg-3 col-sm-6">
							<aside class="widget widget-contact">
								<div class="contact-area">
									<div class="contact-icon">
										<i class="fas <?php echo esc_attr($footer_email_icon); ?>"></i>
									</div>
									<div class="contact-info">
										<p class="text">
											<span><?php echo wp_kses_post($footer_email_title); ?></span>
											<a href="mailto:<?php echo esc_attr($footer_email); ?>">
												<?php echo esc_html($footer_email); ?>
											</a>
										</p>
									</div>
								</div>
							</aside>
						</div>
					<?php endif; ?>	
					
					<?php if(!empty($footer_contact_address) || !empty($footer_address_title)): ?>
						<div class="col-lg-3 col-sm-6">
							<aside class="widget widget-contact">
								<div class="contact-area">
									<div class="contact-icon">
										<i class="fas <?php echo esc_attr($footer_contct_icon); ?>"></i>
									</div>
									<div class="contact-info">
										<p class="text">
											<span><?php echo wp_kses_post($footer_address_title); ?></span>
											<a href="#"><?php echo wp_kses_post($footer_contact_address); ?></a>
										</p>
									</div>
								</div>
							</aside>
						</div>
					<?php endif; ?>	
						
				<?php endif; ?>
				
				<div class="footer_main">
					<?php if ( is_active_sidebar( 'nexcraft-footer-widget' ) ) : ?>
						<div class="row">
							<?php  dynamic_sidebar( 'nexcraft-footer-widget' ); ?>
						</div>
					<?php endif; ?>
				</div>
				
				<div class="footer_copyright">
					<div class="container">
						<div class="copyright_bg">
							<div class="row align-items-center">
								<div class="col-lg-6 col-md-6">
									<?php 	
										$footer_first_custom 		= get_theme_mod('footer_first_custom',__('Copyright &copy; [current_year] [site_title] | Powered by [theme_author]', 'nexcraft' ));
										
										$nexcraft_copyright_allowed_tags = array(
											'[current_year]' => date_i18n('Y', current_time( 'timestamp' )),
											'[site_title]'   => get_bloginfo('name'),
											'[theme_author]' => sprintf(__('<a href="#">%s</a>', 'nexcraft'), esc_html__('NexCraft', 'nexcraft')),
										);
									?>                        
									<p class="copyright-text">
										<?php
											echo apply_filters('nexcraft_footer_copyright', wp_kses_post(nexcraft_str_replace_assoc($nexcraft_copyright_allowed_tags, $footer_first_custom)));
										?>
									</p>
								</div>
								<div class="col-lg-6 col-md-6">
									<aside class="widget widget_payment_methods">
										<ul class="payment_methods">
											<?php if(!empty($footer_mastercard_link)){ ?>
												<li><a href="<?php echo esc_url($footer_mastercard_link); ?>"><i class="fab fa-cc-mastercard"></i></a></li>
											<?php } ?>
											<?php if(!empty($footer_visa_link)){ ?>
												<li><a href="<?php echo esc_url($footer_visa_link); ?>"><i class="fab fa-cc-visa"></i></a></li>
											<?php } ?>
											<?php if(!empty($footer_paypal_link)){ ?>
												<li><a href="<?php echo esc_url($footer_paypal_link); ?>"><i class="fab fa-cc-paypal"></i></a></li>
											<?php } ?>
											<?php if(!empty($footer_amex_link)){ ?>
												<li><a href="<?php echo esc_url($footer_amex_link); ?>"><i class="fab fa-cc-amex"></i></a></li>
											<?php } ?>
											<?php if(!empty($footer_jcb_link)){ ?>
												<li><a href="<?php echo esc_url($footer_jcb_link); ?>"><i class="fab fa-cc-jcb"></i></a></li>
											<?php } ?>
										</ul>
									</aside>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	<div>	
</footer>
<!-- END FOOTER -->

<!-- START: SCROLL UP -->
	<?php 
		$hs_scroller 	= get_theme_mod('hs_scroller','1');	
		if($hs_scroller == '1') :
	?>
	<!-- ======== Back to Top =====- -->
    <!-- scroll-top -->
	<button type="button" class="scrollingUp scroll-btn" aria-label="scrollingUp"><i class="fas fa-angle-double-up"></i></button>
    <!-- ======== End ======== -->
	<?php endif; ?>
<!-- END: SCROLL UP -->
<?php 
wp_footer(); ?>
</body>
</html>
