(function ($) {
    'use strict';

    // Preloader
    function preloader() {        
        setTimeout(function(){
            $(".preloader").fadeOut();
        },100);
    }


    // delicious menu filter
    function activePostFilter() {
        var postFilter = $('.filter-init');
        $.each(postFilter, function (index, value) {
            var el = $(this);
            var parentClass = $(this).parent().attr('class');
            var $selector = $('#' + el.attr('id'));
            $($selector).imagesLoaded(function () {
                var festivarMasonry = $($selector).isotope({
                    itemSelector: '.filter-item',
                    percentPosition: true,
                    masonry: {
                        columnWidth: 0,
                        gutter: 0
                    }
                });
                $('.collapse').on('shown.bs.collapse hidden.bs.collapse', function () {
                    festivarMasonry.isotope('layout');
                });
                $(document).on('click', '.' + parentClass + ' .filter-button-group a', function () {
                    var filterValue = $(this).attr('data-filter');
                    festivarMasonry.isotope({
                        filter: filterValue,
                        animationOptions: {
                            duration: 450,
                            easing: "linear",
                            queue: false,
                        }
                    });
                    return false;
                });
                $('.filter-wrapper2 .filter-button-group li a:first-child').click();
            });
        });
    }
    $(document).on('click', '.filter-button-group a', function () {
        $(this).siblings().removeClass('active');
        $(this).addClass('active');
    });


    // mobile menu
    function mobileMenu() {
        $(".dropdown-toggle").on("click", function(e) {
            // Check if the screen width is less than or equal to 991px
            if (window.innerWidth <= 991) {
              e.preventDefault();
              $(this).parent().toggleClass("current");
              $(this).next().slideToggle();
            }
          });
    }


    

    // BTN SCROLL TOP
    function scrolltop() {
        $(window).on('scroll', function () {
            if ($(this).scrollTop() > 200) {
                $('.scrollingUp').addClass('is-active');
            } else {
                $('.scrollingUp').removeClass('is-active');
            }
        });
        $('.scrollingUp').on('click', function () {
            $("html, body").animate({
                scrollTop: 0
            }, 600);
            return false;
        });
    }

    // menu sticky
    function menuSticky() {
        if ($(".is-sticky-on").length > 0) {
            $(window).on('scroll', function () {
                if ($(window).scrollTop() >= 250) {
                    $('.is-sticky-on').addClass('is-sticky-menu');
                }
                else {
                    $('.is-sticky-on').removeClass('is-sticky-menu');
                }
            });
        }
    }

    //  Masonry
    function masonsary() {
        // blog masonry
        var $grid = $(".grid").masonry({
            // options
            itemSelector: ".grid-item",
            columnWidth: ".grid-item",
            // percentPosition: true,
            gutter: 0,
            fitWidth: false
        });
        
        var gridItems = $(".grid-item"); 
        if (gridItems.length > 0) {
            $grid.imagesLoaded().progress(function () {
                $grid.masonry("layout");
            });
        } else {
        }
        
    }

    // active menus
    function activeMenu() {
        var url = window.location.pathname,
            urlRegExp = new RegExp(url.replace(/\/$/, '') + "$");
        $('.navbar-nav li a').each(function () {
            var currentHref = this.href.replace(/\/$/, '');
            if (urlRegExp.test(currentHref)) {
                $(this).addClass('active');
                $(this).closest('.dropdown').find('.nav-link').addClass('active');
            }
        });
    }

    // counter animation
    function counterUp(){
    $('.counter').counterUp({
        delay: 10,
        time: 1000
    });
    }

    // video play with bootstrap modal
    function playVideo() {
        var $videoSrc;
        $('.video-btn').click(function () {
            $videoSrc = $(this).data("src");
        });
        $('#exampleModal1').on('shown.bs.modal', function (e) {
            $("#video").attr('src', $videoSrc + "?autoplay=1&amp;modestbranding=1&amp;showinfo=0");
        })
        $('#exampleModal1').on('hide.bs.modal', function (e) {
            $("#video").attr('src', $videoSrc);
        })
    }
	
    // width progress top
    function progressTop(){
        $(document).on("scroll", function(){
            var pixels = $(document).scrollTop();
            var pageHeight = $(document).height() - $(window).height();
            var progress = 100 * pixels / pageHeight;
            
            $("div.progress-top").css("width", progress + "%");
          })
    }

    /* $(function () {
        $('[data-bs-toggle="tooltip"]').tooltip();
    }); */


  
	preloader();
	activePostFilter();
	mobileMenu();
	scrolltop();
	menuSticky();
	masonsary();
	activeMenu();
	counterUp();
	playVideo();
	progressTop();

})(jQuery);