<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package NexCraft
 */
get_header();
?>
<section class="section-404">
	<div class="container">
        <div class="row">
            <div class="col-lg-6 mx-auto">
                <div class="card-404">
					<h2 class="error-title">
						<?php echo wp_kses_post('404','nexcraft'); ?>
					</h2>   	
					<h2 class="not-found"><i class="far fa-sad-cry"></i>
						<?php echo wp_kses_post('ops! Something Going Wrong','nexcraft'); ?>
					</h2>  
					<p>
						<?php echo wp_kses_post('The page you are looking for does not exist.','nexcraft'); ?>
					</p>
					<a href="<?php echo esc_url( home_url( '/' )); ?>" class="main-btn"><?php echo esc_html_e('Back To Home','nexcraft'); ?></a>
				</div>
			</div>
		</div>
	</div>
</section>
<?php get_footer(); ?>
