<?php
define( 'NEXCRAFT_BPO_THEME_VERSION', '1.3' );
function nexcraft_bpo_css() {
	$parent_style = 'nexcraft-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'nexcraft-bpo-style', get_stylesheet_uri(), array( $parent_style ));
	
	wp_dequeue_style('nexcraft-default-css',get_template_directory_uri().'/assets/css/color/default.css');
	wp_enqueue_style( 'nexcraft-bpo-default-css', get_stylesheet_directory_uri().'/assets/css/color/default.css');
}
add_action( 'wp_enqueue_scripts', 'nexcraft_bpo_css',999);

function nexcraft_bpo_setup(){
	add_theme_support( 'title-tag' );
	add_theme_support( 'automatic-feed-links' );
}
add_action( 'after_setup_theme', 'nexcraft_bpo_setup' );

require( get_stylesheet_directory() . '/inc/customizer/nexcraft-bpo-premium.php');

/**
 * Custom functions that act independently of the theme templates.
 */
require( get_stylesheet_directory() . '/inc/extras.php');

/**
 * Import Options From Parent Theme
 *
 */
function nexcraft_bpo_parent_theme_options() {
	$nexcraft_mods = get_option( 'theme_mods_nexcraft' );
	if ( ! empty( $nexcraft_mods ) ) {
		foreach ( $nexcraft_mods as $nexcraft_mod_k => $nexcraft_mod_v ) {
			set_theme_mod( $nexcraft_mod_k, $nexcraft_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'nexcraft_bpo_parent_theme_options' );

function nexcraft_custom_header_three_setup() {
	add_theme_support( 'custom-header', apply_filters( 'nexcraft_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => '000000',
		'width'                  => 2000,
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'nexcraft_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'nexcraft_custom_header_three_setup' );

