<?php
function callcenter_header_settings( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	/*=========================================
	Header Settings Panel
	=========================================*/
	$wp_customize->add_panel( 
		'header_section', 
		array(
			'priority'      => 2,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Header', 'call-center'),
		) 
	);

	
	/*=========================================
	Call Center Site Identity
	=========================================*/
	$wp_customize->add_section(
        'title_tagline',
        array(
        	'priority'      => 1,
            'title' 		=> __('Site Identity','call-center'),
			'panel'  		=> 'header_section',
		)
    );


	// topheader Logo Height
	$topheaderlogoheight = esc_html__('70', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_logoheight',
    	array(
			'default' => $topheaderlogoheight,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'topheader_logoheight',
		array(
		    'label'   		=> __('Logo Size','call-center'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'range',
			'transport'         => $selective_refresh,
		)  
	);	


	// top header Site Title Color
	$topheadersitetitlecol = esc_html__('#646464', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_sitetitlecol',
    	array(
			'default' => $topheadersitetitlecol,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_sitetitlecol',
		array(
		    'label'   		=> __('Site Title Color','call-center'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// top header Tagline Color
	$topheadertaglinecol = esc_html__('#fff', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_taglinecol',
    	array(
			'default' => $topheadertaglinecol,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'topheader_taglinecol',
		array(
		    'label'   		=> __('Tagline Color','call-center'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);



	// // topheader Button Color
	// $topheaderstickycolor = esc_html__('#509e39', 'call-center' );
	// $wp_customize->add_setting(
 //    	'topheader_stickycolor',
 //    	array(
	// 		'default' => $topheaderstickycolor,
	// 		'capability'     	=> 'edit_theme_options',
	// 		'sanitize_callback' => 'wp_kses_post',
	// 		'priority'      => 2,
	// 	)
	// );	

	// $wp_customize->add_control( 
	// 	'topheader_stickycolor',
	// 	array(
	// 	    'label'   		=> __('Header Color','call-center'),
	// 	    'section'		=> 'sticky_header_set',
	// 		'type' 			=> 'color',
	// 		'transport'         => $selective_refresh,
	// 	)  
	// );	
	


	/*=========================================
	Call Center header
	=========================================*/
	$wp_customize->add_section(
        'top_header',
        array(
        	'priority'      => 5,
            'title' 		=> __('Header','call-center'),
			'panel'  		=> 'header_section',
		)
    );	

	
	$wp_customize->add_setting('callcenter_reset_header_settings',array(
		'sanitize_callback'   => 'sanitize_text_field'
	  ));
	  $wp_customize->add_control(new callcenter_Reset_Custom_Control($wp_customize, 'callcenter_reset_header_settings',array(
		'type' => 'reset_control',
		 'priority' => 1,
		'label' => __('Reset Header Settings', 'call-center'),
		'description' => 'callcenter_header_reset_settings',
		'section' => 'top_header'
	  )));
  
  
  
	  $wp_customize->add_setting('callcenter_top_header_tabs', array(
		 'sanitize_callback' => 'wp_kses_post',
	  ));
  
	  $wp_customize->add_control(new callcenter_Tab_Control($wp_customize, 'callcenter_top_header_tabs', array(
		 'section' => 'top_header',
		 'priority' => 1,
		 'buttons' => array(
			array(
			   'name' => esc_html__('General', 'call-center'),
			   'icon' => 'dashicons dashicons-welcome-write-blog',
			  'fields' => array(
				  'hide_show_sticky',
				  'topheader_phn',
				  'topheader_phnicon'
  
			  ),
			  'active' => true,
		   ),
			array(
			  'name' => esc_html__('Style', 'call-center'),
			  'icon' => 'dashicons dashicons-art',
			  'fields' => array(
				  'topheader_grdcol1',
				  'topheader_grdcol2',
				  'topheader_menu_col',
				  'topheader_menuhrv_col',
				  'topheader_submenu_col',
				  'topheader_submenubg1_col',
				  'topheader_submenubg2_col',
				  'topheader_submenuhrv_col'
  
			  ),
		   )
		  
		  ),
	  )));
  
  

	// general

	// sticky header
	$wp_customize->add_setting( 'hide_show_sticky',array(
        'default' => false,
        'sanitize_callback' => 'callcenter_switch_sanitization'
   	) );
   	$wp_customize->add_control( new callcenter_Toggle_Switch_Custom_Control( $wp_customize, 'hide_show_sticky',array(
        'label' => __( 'Show Sticky Header','call-center' ),
        'section' => 'top_header'
   	)));


	// topheader Phone Number
	$topheaderphn = esc_html__('+386 40 111 5555', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_phn',
    	array(
			'default' => $topheaderphn,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phn',
		array(
		    'label'   		=> __('Phone Number','call-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);		


	// topheader phone number icon
	$topheaderphnicon = esc_html__('fa fa-phone', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_phnicon',
    	array(
			'default' => $topheaderphnicon,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phnicon',
		array(
		    'label'   		=> __('Phone Number Icon','call-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'icon',
			'transport'         => $selective_refresh,
		)  
	);	


	// style

	// topheader gradient color 1
	$topheadergrdcol1 = esc_html__('#437fc7', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_grdcol1',
    	array(
			'default' => $topheadergrdcol1,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'topheader_grdcol1',
		array(
		    'label'   		=> __('Header Color 1','call-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// topheader gradient color 2
	$topheadergrdcol2 = esc_html__('#88b7f1', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_grdcol2',
    	array(
			'default' => $topheadergrdcol2,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_grdcol2',
		array(
		    'label'   		=> __('Header Color 2','call-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	
	
	// topheader menu color
	$topheadermenu_col = esc_html__('#000', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_menu_col',
    	array(
			'default' => $topheadermenu_col,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_menu_col',
		array(
		    'label'   		=> __('Menu Color','call-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// topheader menuhrv color
	$topheadermenuhrv_col = esc_html__('#437fc7', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_menuhrv_col',
    	array(
			'default' => $topheadermenuhrv_col,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_menuhrv_col',
		array(
		    'label'   		=> __('Menu Hover Color','call-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// topheader_submenu color
	$topheade_submenu_col = esc_html__('#fff', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_submenu_col',
    	array(
			'default' => $topheade_submenu_col,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_submenu_col',
		array(
		    'label'   		=> __('Sub Menu Color','call-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// topheader submenubg1 color
	$topheadersubmenubg1_col = esc_html__('#4380c8', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_submenubg1_col',
    	array(
			'default' => $topheadersubmenubg1_col,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_submenubg1_col',
		array(
		    'label'   		=> __('Sub Menu BG Color 1','call-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// topheader submenubg2 color
	$topheadersubmenubg2_col = esc_html__('#6daffe', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_submenubg2_col',
    	array(
			'default' => $topheadersubmenubg2_col,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_submenubg2_col',
		array(
		    'label'   		=> __('Sub Menu BG Color 2','call-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// topheader submenuhrv color
	$topheadersubmenuhrv_col = esc_html__('#000', 'call-center' );
	$wp_customize->add_setting(
    	'topheader_submenuhrv_col',
    	array(
			'default' => $topheadersubmenuhrv_col,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_submenuhrv_col',
		array(
		    'label'   		=> __('Sub Menu Hover Color','call-center'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	$wp_customize->register_control_type('callcenter_Tab_Control');

}
add_action( 'customize_register', 'callcenter_header_settings' );





