<?php
function callcenter_blog_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
			'callcenter_frontpage_sections', array(
				'priority' => 32,
				'title' => esc_html__( 'Frontpage Sections', 'call-center' ),
			)
		);
	

	/*=========================================
	Slider Section
	=========================================*/
	$wp_customize->add_section(
		'slider_setting', array(
			'title' => esc_html__( 'Slider Section', 'call-center' ),
			'priority' => 13,
			'panel' => 'callcenter_frontpage_sections',
		)
	);
	
	$wp_customize->add_setting('callcenter_reset_slider_settings',array(
		'sanitize_callback'   => 'sanitize_text_field'
	));
	$wp_customize->add_control(new callcenter_Reset_Custom_Control($wp_customize, 'callcenter_reset_slider_settings',array(
		'type' => 'reset_control',
			'priority' => 1,
		'label' => __('Reset Slider Settings', 'call-center'),
		'description' => 'callcenter_slider_reset_settings',
		'section' => 'slider_setting'
	)));

	$wp_customize->add_setting('callcenter_slider_setting_tabs', array(
		'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new callcenter_Tab_Control($wp_customize, 'callcenter_slider_setting_tabs', array(
		'section' => 'slider_setting',
		'priority' => 1,
		'buttons' => array(
		array(
			'name' => esc_html__('General', 'call-center'),
			'icon' => 'dashicons dashicons-welcome-write-blog',
			'fields' => array(
				'slider1',
				'slider2',
				'slider3',
				'slider4',
				'slider5',
				'slider_icon1',
				'slider_icon2',
				'slider_icon3',
				'slider_icon4'

			),
			'active' => true,
		),
		array(
			'name' => esc_html__('Style', 'call-center'),
			'icon' => 'dashicons dashicons-art',
			'fields' => array(
				'slider_title_color',
				'slider_description_color',
				'slider_btntext_color',
				'slider_btnbg1_color',
				'slider_btnbg2_color',
				'slider_btntexthover_color',
				'slider_btnbghover_color',
				'slider_socialicon_color',
				'slider_socialiconhrv_color'

			),
		)
		
		),
	)));
	


	// Slider 1
	$wp_customize->add_setting( 
    	'slider1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'slider1',
		array(
		    'label'   		=> __('Slider 1','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		



	// Slider 2
	$wp_customize->add_setting(
    	'slider2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'slider2',
		array(
		    'label'   		=> __('Slider 2','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 3
	$wp_customize->add_setting(
    	'slider3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider3',
		array(
		    'label'   		=> __('Slider 3','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 4
	$wp_customize->add_setting(
    	'slider4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'slider4',
		array(
		    'label'   		=> __('Slider 4','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);



	// Slider 5
	$wp_customize->add_setting(
    	'slider5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'slider5',
		array(
		    'label'   		=> __('Slider 5','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);


	// slider icon 1 Section
	$slidericon1 = esc_html__('fa fa-phone', 'call-center' );
	$wp_customize->add_setting(
    	'slider_icon1',
    	array(
			'default' => $slidericon1,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider_icon1',
		array(
		    'label'   		=> __('Icon 1','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider icon 1 Section
	$slidericon1 = esc_html__('fa fa-facebook', 'call-center' );
	$wp_customize->add_setting(
    	'slider_icon1',
    	array(
			'default' => $slidericon1,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider_icon1',
		array(
		    'label'   		=> __('Icon 1','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'icon',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider icon 2 Section
	$slidericon2 = esc_html__('fa fa-instagram', 'call-center' );
	$wp_customize->add_setting(
    	'slider_icon2',
    	array(
			'default' => $slidericon2,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider_icon2',
		array(
		    'label'   		=> __('Icon 2','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'icon',
			'transport'         => $selective_refresh,
		)  
	);	


	// slider icon 3 Section
	$slidericon3 = esc_html__('fa fa-twitter', 'call-center' );
	$wp_customize->add_setting(
    	'slider_icon3',
    	array(
			'default' => $slidericon3,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'slider_icon3',
		array(
		    'label'   		=> __('Icon 3','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'icon',
			'transport'         => $selective_refresh,
		)  
	);	


	// slider icon 4 Section
	$slidericon4 = esc_html__('fa fa-linkedin', 'call-center' );
	$wp_customize->add_setting(
    	'slider_icon4',
    	array(
			'default' => $slidericon4,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 10,
		)
	);	

	$wp_customize->add_control( 
		'slider_icon4',
		array(
		    'label'   		=> __('Icon 4','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'icon',
			'transport'         => $selective_refresh,
		)  
	);	

	//style

	// slider title color
	$slider_title_color = esc_html__('#000', 'call-center' );
	$wp_customize->add_setting(
    	'slider_title_color',
    	array(
			'default' => $slider_title_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider_title_color',
		array(
		    'label'   		=> __('Title Color','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider description color
	$slider_description_color = esc_html__('#979b9d', 'call-center' );
	$wp_customize->add_setting(
    	'slider_description_color',
    	array(
			'default' => $slider_description_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider_description_color',
		array(
		    'label'   		=> __('Description Color','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider btntext color
	$slider_btntext_color = esc_html__('#fff', 'call-center' );
	$wp_customize->add_setting(
    	'slider_btntext_color',
    	array(
			'default' => $slider_btntext_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider_btntext_color',
		array(
		    'label'   		=> __('Button Text Color','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// slider btnbg1 color
	$slider_btnbg1_color = esc_html__('#53a4e4', 'call-center' );
	$wp_customize->add_setting(
    	'slider_btnbg1_color',
    	array(
			'default' => $slider_btnbg1_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider_btnbg1_color',
		array(
		    'label'   		=> __('Button BG Color 1','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider btnbg2 color
	$slider_btnbg2_color = esc_html__('#297cde', 'call-center' );
	$wp_customize->add_setting(
    	'slider_btnbg2_color',
    	array(
			'default' => $slider_btnbg2_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider_btnbg2_color',
		array(
		    'label'   		=> __('Button BG Color 2','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider btntexthover color
	$slider_btntexthover_color = esc_html__('#fff', 'call-center' );
	$wp_customize->add_setting(
    	'slider_btntexthover_color',
    	array(
			'default' => $slider_btntexthover_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider_btntexthover_color',
		array(
		    'label'   		=> __('Button Text Hover Color','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider btnbghover color
	$slider_btnbghover_color = esc_html__('#297cde', 'call-center' );
	$wp_customize->add_setting(
    	'slider_btnbghover_color',
    	array(
			'default' => $slider_btnbghover_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider_btnbghover_color',
		array(
		    'label'   		=> __('Button BG Hover Color','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider socialicon color
	$slider_socialicon_color = esc_html__('#fff', 'call-center' );
	$wp_customize->add_setting(
    	'slider_socialicon_color',
    	array(
			'default' => $slider_socialicon_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider_socialicon_color',
		array(
		    'label'   		=> __('Social Icon Color','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider socialiconhrv color
	$slider_socialiconhrv_color = esc_html__('#000', 'call-center' );
	$wp_customize->add_setting(
    	'slider_socialiconhrv_color',
    	array(
			'default' => $slider_socialiconhrv_color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider_socialiconhrv_color',
		array(
		    'label'   		=> __('Social Icon Hover Color','call-center'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	

	/*=========================================
	Service Section
	=========================================*/
	$wp_customize->add_section(
		'Service_setting', array(
			'title' => esc_html__( 'Service Section', 'call-center' ),
			'priority' => 14,
			'panel' => 'callcenter_frontpage_sections',
		)
	);


	$wp_customize->add_setting('callcenter_reset_Service_settings',array(
		'sanitize_callback'   => 'sanitize_text_field'
	));
	$wp_customize->add_control(new callcenter_Reset_Custom_Control($wp_customize, 'callcenter_reset_Service_settings',array(
		'type' => 'reset_control',
			'priority' => 1,
		'label' => __('Reset Service Settings', 'call-center'),
		'description' => 'callcenter_Service_reset_settings',
		'section' => 'Service_setting'
	)));

	$wp_customize->add_setting('callcenter_Service_setting_tabs', array(
		'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new callcenter_Tab_Control($wp_customize, 'callcenter_Service_setting_tabs', array(
		'section' => 'Service_setting',
		'priority' => 1,
		'buttons' => array(
		array(
			'name' => esc_html__('General', 'call-center'),
			'icon' => 'dashicons dashicons-welcome-write-blog',
			'fields' => array(
				'Service1',
				'Service2',
				'Service3',
				'Service4',
				'Service5',
				'Service6'

			),
			'active' => true,
		),
		array(
			'name' => esc_html__('Style', 'call-center'),
			'icon' => 'dashicons dashicons-art',
			'fields' => array(
				'color_service1',
				'color_service2',
				'service_titlecolor',
				'service_descriptioncolor',
				'service_btntextbrdcolor',
				'service_btntexthrvcolor',
				'service_btnbghrvcolor'

			),
		),
			array(
            'name' => esc_html__('Layout', 'call-center'),
            'icon' => 'dashicons dashicons-layout',
            'fields' => array(
                'service_section_width',

            ),
         )
		
		),
	)));
	

		// Layout
	
	$wp_customize->add_setting('service_section_width',array(
        'default' => 'Box Width',
        'sanitize_callback' => 'callcenter_sanitize_choices',
    ));
    $wp_customize->add_control('service_section_width',array(
        'type' => 'select',
        'label' => __('Section Width','call-center'),
        'choices' => array (
            'Box Width' => __('Box Width','call-center'),
            'Full Width' => __('Full Width','call-center')
        ),
        'section' => 'Service_setting',
    ));


	// Service 1
	$wp_customize->add_setting( 
    	'Service1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'Service1',
		array(
		    'label'   		=> __('Service 1','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		



	// Service 2
	$wp_customize->add_setting(
    	'Service2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'Service2',
		array(
		    'label'   		=> __('Service 2','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Service 3
	$wp_customize->add_setting(
    	'Service3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'Service3',
		array(
		    'label'   		=> __('Service 3','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Service 4
	$wp_customize->add_setting(
    	'Service4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'Service4',
		array(
		    'label'   		=> __('Service 4','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);



	// Service 5
	$wp_customize->add_setting(
    	'Service5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'Service5',
		array(
		    'label'   		=> __('Service 5','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);


	// Service 6
	$wp_customize->add_setting(
    	'Service6',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'Service6',
		array(
		    'label'   		=> __('Service 6','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);



	// Color Section
	$colorservice1 = esc_html__('#4581c9', 'call-center' );
	$wp_customize->add_setting(
    	'color_service1',
    	array(
			'default' => $colorservice1,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'color_service1',
		array(
		    'label'   		=> __('Color 1','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// Color Section 2
	$colorservice2 = esc_html__('#6babf8', 'call-center' );
	$wp_customize->add_setting(
    	'color_service2',
    	array(
			'default' => $colorservice2,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'color_service2',
		array(
		    'label'   		=> __('Color 2','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	
	
	// service title color
	$servicetitlecolor = esc_html__('#000', 'call-center' );
	$wp_customize->add_setting(
    	'service_titlecolor',
    	array(
			'default' => $servicetitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'service_titlecolor',
		array(
		    'label'   		=> __('Title Color','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// service description color
	$servicedescriptioncolor = esc_html__('#6c7376', 'call-center' );
	$wp_customize->add_setting(
    	'service_descriptioncolor',
    	array(
			'default' => $servicedescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'service_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// service btntextbrd color
	$servicebtntextbrdcolor = esc_html__('#36aff1', 'call-center' );
	$wp_customize->add_setting(
    	'service_btntextbrdcolor',
    	array(
			'default' => $servicebtntextbrdcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'service_btntextbrdcolor',
		array(
		    'label'   		=> __('Button Color','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// service btntexthrv color
	$servicebtntexthrvcolor = esc_html__('#fff', 'call-center' );
	$wp_customize->add_setting(
    	'service_btntexthrvcolor',
    	array(
			'default' => $servicebtntexthrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'service_btntexthrvcolor',
		array(
		    'label'   		=> __('Button Text Hover Color','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// service btnbghrv color
	$servicebtnbghrvcolor = esc_html__('#002c8b', 'call-center' );
	$wp_customize->add_setting(
    	'service_btnbghrvcolor',
    	array(
			'default' => $servicebtnbghrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'service_btnbghrvcolor',
		array(
		    'label'   		=> __('Button BG Hover Color','call-center'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	



}

add_action( 'customize_register', 'callcenter_blog_setting' );

// service selective refresh
function callcenter_blog_section_partials( $wp_customize ){	
	// blog_title
	$wp_customize->selective_refresh->add_partial( 'blog_title', array(
		'selector'            => '.home-blog .title h6',
		'settings'            => 'blog_title',
		'render_callback'  => 'callcenter_blog_title_render_callback',
	
	) );
	
	// blog_subtitle
	$wp_customize->selective_refresh->add_partial( 'blog_subtitle', array(
		'selector'            => '.home-blog .title h2',
		'settings'            => 'blog_subtitle',
		'render_callback'  => 'callcenter_blog_subtitle_render_callback',
	
	) );
	
	// blog_description
	$wp_customize->selective_refresh->add_partial( 'blog_description', array(
		'selector'            => '.home-blog .title p',
		'settings'            => 'blog_description',
		'render_callback'  => 'callcenter_blog_description_render_callback',
	
	) );	
	}

add_action( 'customize_register', 'callcenter_blog_section_partials' );

// blog_title
function callcenter_blog_title_render_callback() {
	return get_theme_mod( 'blog_title' );
}

// blog_subtitle
function callcenter_blog_subtitle_render_callback() {
	return get_theme_mod( 'blog_subtitle' );
}

// service description
function callcenter_blog_description_render_callback() {
	return get_theme_mod( 'blog_description' );
}