<?php
function callcenter_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'callcenter_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => '646464',
		'width'                  => 2000, 
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'callcenter_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'callcenter_custom_header_setup' );

if ( ! function_exists( 'callcenter_header_style' ) ) :

function callcenter_header_style() {
		$header_text_color = get_header_textcolor();
		$topheader_logoheight = get_theme_mod('topheader_logoheight','70');

		$topheader_sitetitlecol = get_theme_mod('topheader_sitetitlecol','#646464');

		$topheader_taglinecol = get_theme_mod('topheader_taglinecol','#fff');



		$topheader_menu_col = get_theme_mod('topheader_menu_col','#000');
		$topheader_menuhrv_col = get_theme_mod('topheader_menuhrv_col','#437fc7');
		$topheader_submenu_col = get_theme_mod('topheader_submenu_col','#fff');
		$topheader_submenubg1_col = get_theme_mod('topheader_submenubg1_col','#4380c8');
		$topheader_submenubg2_col = get_theme_mod('topheader_submenubg2_col','#6daffe');
		$topheader_submenuhrv_col = get_theme_mod('topheader_submenuhrv_col','#000');



		$service_titlecolor = get_theme_mod('service_titlecolor','#000');
		$service_descriptioncolor = get_theme_mod('service_descriptioncolor','#6c7376');
		$service_btntextbrdcolor = get_theme_mod('service_btntextbrdcolor','#36aff1');
		$service_btntexthrvcolor = get_theme_mod('service_btntexthrvcolor','#fff');
		$service_btnbghrvcolor = get_theme_mod('service_btnbghrvcolor','#002c8b');


	?>
	<style type="text/css">

		<?php 
		
		?>

		.custom-logo {
			height: <?php echo apply_filters('houdabusiness_topheader', $topheader_logoheight); ?>px;
		}

		h4.site-title {
			color: <?php echo apply_filters('houdabusiness_topheader', $topheader_sitetitlecol); ?>;
		}

		p.site-description {
			color: <?php echo apply_filters('houdabusiness_topheader', $topheader_taglinecol); ?>;
		}



		.main-header .navbar .navbar-menu ul li a,
		.main-header .navbar .navbar-menu ul li.dropdown>a::after {
			color: <?php echo apply_filters('houdabusiness_topheader', $topheader_menu_col); ?>;
		}

		.main-header .navbar .navbar-menu ul li a:hover,
		.main-header .navbar .navbar-menu ul li:hover.dropdown>a::after {
			color: <?php echo apply_filters('houdabusiness_topheader', $topheader_menuhrv_col); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:not(.remove) {
			color: <?php echo apply_filters('houdabusiness_topheader', $topheader_submenu_col); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu {
			background-image: radial-gradient( circle farthest-corner at 10% 20%,<?php echo apply_filters('houdabusiness_topheader', $topheader_submenubg1_col); ?> 0%,<?php echo apply_filters('houdabusiness_topheader', $topheader_submenubg2_col); ?> 100.3% ) !important;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:hover {
			color: <?php echo apply_filters('houdabusiness_topheader', $topheader_submenuhrv_col); ?>;
		}



		/* slider */
		.hero-style .slide-title h2 {
			color: <?php echo esc_attr(get_theme_mod('slider_title_color')); ?>;
		}

		.hero-style .slide-text p {
			color: <?php echo esc_attr(get_theme_mod('slider_description_color')); ?>;
		}

		.hero-style a.ReadMore {
			color: <?php echo esc_attr(get_theme_mod('slider_btntext_color')); ?> !important;
		}

		.hero-style a.ReadMore {
			background: linear-gradient(to left,<?php echo esc_attr(get_theme_mod('slider_btnbg1_color')); ?> 30%,<?php echo esc_attr(get_theme_mod('slider_btnbg2_color')); ?> 80%);
		}

		.hero-style a.ReadMore:hover {
			color: <?php echo esc_attr(get_theme_mod('slider_btntexthover_color')); ?> !important;
		}

		.hero-style a.ReadMore:hover {
			background: <?php echo esc_attr(get_theme_mod('slider_btnbghover_color')); ?> !important;
		}

		.slider-area .slidericons i {
			color: <?php echo esc_attr(get_theme_mod('slider_socialicon_color')); ?>;
		}

		.slider-area .slidericons i:hover {
			color: <?php echo esc_attr(get_theme_mod('slider_socialiconhrv_color')); ?>;
		}



		/* service */

		#service-section .single-service .part-2 h3.title {
			color: <?php echo esc_attr(get_theme_mod('service_titlecolor')); ?>;
		}

		#service-section .single-service .part-2 p {
			color: <?php echo esc_attr(get_theme_mod('service_descriptioncolor')); ?>;
		}

		#service-section .single-service .part-2 a {
			color: <?php echo esc_attr(get_theme_mod('service_btntextbrdcolor')); ?>;
		}
		#service-section .single-service .part-2 a {
			border-color: <?php echo esc_attr(get_theme_mod('service_btntextbrdcolor')); ?>;
		}

		#service-section .single-service .part-2 a:hover {
			color: <?php echo esc_attr(get_theme_mod('service_btntexthrvcolor')); ?>;
		}

		#service-section .single-service .part-2 a:hover {
			background: <?php echo esc_attr(get_theme_mod('service_btnbghrvcolor')); ?>;
		}

		
		<?php  ?>
	<?php
		if ( ! display_header_text() ) :
	?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px, 1px, 1px, 1px);
		}
	<?php
		else :
	?>
		h4.site-title a{
			color: #<?php echo esc_attr( $header_text_color ); ?>;
		}
	<?php endif; ?>
	</style>
	<?php
}
endif;
