<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta http-equiv="Content-Type" content="<?php echo esc_attr(get_bloginfo('html_type')); ?>; charset=<?php echo esc_attr(get_bloginfo('charset')); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.2, user-scalable=yes" />

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php
	if ( function_exists( 'wp_body_open' ) )
	{
		wp_body_open();
	}else{
		do_action('wp_body_open');
	}
?>

<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'call-center-bpo' ); ?></a>

<?php if(get_theme_mod('call_center_bpo_site_loader',false)!= ''){ ?>
    <?php if(get_theme_mod( 'call_center_bpo_preloader_type','four-way-loader') == 'four-way-loader'){ ?>
	    <div class="cssloader">
	    	<div class="sh1"></div>
	    	<div class="sh2"></div>
	    	<h1 class="lt"><?php esc_html_e( 'loading',  'call-center-bpo' ); ?></h1>
	    </div>
    <?php }else if(get_theme_mod( 'call_center_bpo_preloader_type') == 'cube-loader') {?>
		<div class="cssloader">
    		<div class="loader-main ">
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
			</div>
    	</div>
    <?php }?>
<?php }?>

<header id="site-navigation">
	<div class="container">
		<div class="row wow fadeInDown">
			<div class="col-lg-3 col-md-12 col-sm-12 align-self-center">
				<div class="logo text-center text-lg-start">
		    		<div class="logo-image">
		    			<?php the_custom_logo(); ?>
			    	</div>
			    	<div class="logo-content">
				    	<?php
				    		if ( get_theme_mod('call_center_bpo_display_header_title', true) == true ) :
					      		echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';
					      			echo esc_html(get_bloginfo('name'));
					      		echo '</a>';
					      	endif;

					      	if ( get_theme_mod('call_center_bpo_display_header_text', true) == true ) :
				      			echo '<span>'. esc_html(get_bloginfo('description')) . '</span>';
				      		endif;
			    		?>
					</div>
				</div>
			</div>
			<div class="col-lg-5 col-md-6 col-sm-6 text-center align-self-center">
				<?php if(has_nav_menu('main-menu')){ ?>
					<button class="menu-toggle my-2 py-2 px-3" aria-controls="top-menu" aria-expanded="false" type="button">
						<span aria-hidden="true"><?php esc_html_e( 'Menu', 'call-center-bpo' ); ?></span>
					</button>
					<nav id="main-menu" class="close-panal">
						<?php
							wp_nav_menu( array(
								'theme_location' => 'main-menu',
								'container' => 'false'
							));
						?>
						<button class="close-menu my-2 p-2" type="button">
							<span aria-hidden="true"><i class="fa fa-times"></i></span>
						</button>
					</nav>
				<?php }?>
			</div>
			<div class="col-lg-2 col-md-3 col-sm-3 align-self-center">
				<?php if ( get_theme_mod('call_center_bpo_header_button_text')  || get_theme_mod('call_center_bpo_header_button_url') ) : ?>
	            	<p class="slider-button my-md-0 my-4 text-center text-md-end"><a href="<?php echo esc_url(get_theme_mod('call_center_bpo_header_button_url'));?>"><?php echo esc_html(get_theme_mod('call_center_bpo_header_button_text'));?></a></p>
	            <?php endif; ?>
			</div>
			<div class="col-lg-2 col-md-3 col-sm-3 align-self-center mb-3 mb-md-0">
				<?php $call_center_bpo_settings = get_theme_mod( 'call_center_bpo_social_links_settings' ); ?>
				<div class="social-links text-center text-md-end">
					<?php if ( is_array($call_center_bpo_settings) || is_object($call_center_bpo_settings) ){ ?>
				    	<?php foreach( $call_center_bpo_settings as $call_center_bpo_setting ) { ?>
					        <a href="<?php echo esc_url( $call_center_bpo_setting['link_url'] ); ?>">
					            <i class="<?php echo esc_attr( $call_center_bpo_setting['link_text'] ); ?>"></i>
					        </a>
				    	<?php } ?>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</header>
