<?php

/*-----------------------------------------------------------------------------------*/
/* Enqueue script and styles */
/*-----------------------------------------------------------------------------------*/

function call_center_bpo_enqueue_google_fonts() {

	require_once get_theme_file_path( 'core/includes/wptt-webfont-loader.php' );

	wp_enqueue_style(
		'google-fonts-outfit',
		wptt_get_webfont_url( 'https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap' ),
		array(),
		'1.0'
	);
}
add_action( 'wp_enqueue_scripts', 'call_center_bpo_enqueue_google_fonts' );

if (!function_exists('call_center_bpo_enqueue_scripts')) {

	function call_center_bpo_enqueue_scripts() {

		wp_enqueue_style(
			'bootstrap-css',
			get_template_directory_uri() . '/css/bootstrap.css',
			array(),'4.5.0'
		);

		wp_enqueue_style(
			'fontawesome-css',
			get_template_directory_uri() . '/css/fontawesome-all.css',
			array(),'4.5.0'
		);

		wp_enqueue_style(
			'owl.carousel-css',
			get_template_directory_uri() . '/css/owl.carousel.css',
			array(),'2.3.4'
		);

		wp_enqueue_style( 'call-center-bpo-block-style', get_theme_file_uri('/css/blocks.css') );

		wp_enqueue_style('call-center-bpo-style', get_stylesheet_uri(), array() );

		wp_enqueue_style(
			'call-center-bpo-media-css',
			get_template_directory_uri() . '/css/media.css',
			array(),'2.3.4'
		);

		wp_enqueue_style(
			'call-center-bpo-woocommerce-css',
			get_template_directory_uri() . '/css/woocommerce.css',
			array(),'2.3.4'
		);

		wp_enqueue_style('dashicons');

		wp_enqueue_script(
			'call-center-bpo-navigation',
			get_template_directory_uri() . '/js/navigation.js',
			FALSE,
			'1.0',
			TRUE
		);

		wp_enqueue_script(
			'owl.carousel-js',
			get_template_directory_uri() . '/js/owl.carousel.js',
			array('jquery'),
			'2.3.4',
			TRUE
		);

		wp_enqueue_script(
			'call-center-bpo-script',
			get_template_directory_uri() . '/js/script.js',
			array('jquery'),
			'1.0',
			TRUE
		);

		if ( get_theme_mod( 'call_center_bpo_animation_enabled', true ) ) {
	        wp_enqueue_script(
	            'call-center-bpo-wow-script',
	            get_template_directory_uri() . '/js/wow.js',
	            array( 'jquery' ),
	            '1.0',
	            true
	        );

	        wp_enqueue_style(
	            'call-center-bpo-animate',
	            get_template_directory_uri() . '/css/animate.css',
	            array(),
	            '4.1.1'
	        );
	    }	

		if ( is_singular() ) wp_enqueue_script( 'comment-reply' );

		$call_center_bpo_css = '';

		if ( get_header_image() ) :

			$call_center_bpo_css .=  '
				#site-navigation,.page-template-frontpage #site-navigation{
					background-image: url('.esc_url(get_header_image()).');
					-webkit-background-size: cover !important;
					-moz-background-size: cover !important;
					-o-background-size: cover !important;
					background-size: cover !important;
				}';

		endif;

		wp_add_inline_style( 'call-center-bpo-style', $call_center_bpo_css );

		// Theme Customize CSS.
		require get_template_directory(). '/core/includes/inline.php';
		wp_add_inline_style( 'call-center-bpo-style',$call_center_bpo_custom_css );

	}

	add_action( 'wp_enqueue_scripts', 'call_center_bpo_enqueue_scripts' );
}

/*-----------------------------------------------------------------------------------*/
/* Setup theme */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('call_center_bpo_after_setup_theme')) {

	function call_center_bpo_after_setup_theme() {

		load_theme_textdomain( 'call-center-bpo', get_stylesheet_directory() . '/languages' );
		
		if ( ! isset( $content_width ) ) $content_width = 900;

		register_nav_menus( array(
			'main-menu' => esc_html__( 'Main menu', 'call-center-bpo' ),
		));

		add_theme_support( 'responsive-embeds' );
		add_theme_support( 'woocommerce' );
		add_theme_support( 'align-wide' );
		add_theme_support('title-tag');
		add_theme_support('automatic-feed-links');
		add_theme_support( 'wp-block-styles' );
		add_theme_support('post-thumbnails');
		add_theme_support( 'custom-background', array(
		  'default-color' => 'f3f3f3'
		));

		add_theme_support( 'custom-logo', array(
			'height'      => 70,
			'width'       => 70,
		) );

		add_theme_support( 'custom-header', array(
			'header-text' => false,
			'width' => 1920,
			'height' => 100
		));

		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

		add_editor_style( array( '/css/editor-style.css' ) );
	}

	add_action( 'after_setup_theme', 'call_center_bpo_after_setup_theme', 999 );

}
require get_template_directory() .'/core/includes/customizer-notice/call-center-bpo-customizer-notify.php';
require get_template_directory() .'/core/includes/main.php';
require get_template_directory() .'/core/includes/theme-breadcrumb.php';
require get_template_directory() .'/core/includes/tgm.php';
require get_template_directory() . '/core/includes/customizer.php';
load_template( trailingslashit( get_template_directory() ) . '/core/includes/class-upgrade-pro.php' );

/*-----------------------------------------------------------------------------------*/
/* Enqueue theme logo style */
/*-----------------------------------------------------------------------------------*/
function call_center_bpo_logo_resizer() {

    $call_center_bpo_theme_logo_size_css = '';
    $call_center_bpo_logo_resizer = get_theme_mod('call_center_bpo_logo_resizer');

	$call_center_bpo_theme_logo_size_css = '
		.custom-logo{
			height: '.esc_attr($call_center_bpo_logo_resizer).'px !important;
			width: '.esc_attr($call_center_bpo_logo_resizer).'px !important;
		}
	';
    wp_add_inline_style( 'call-center-bpo-style',$call_center_bpo_theme_logo_size_css );

}
add_action( 'wp_enqueue_scripts', 'call_center_bpo_logo_resizer' );

/*-----------------------------------------------------------------------------------*/
/* Get post comments */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('call_center_bpo_comment')) :
    /**
     * Template for comments and pingbacks.
     *
     * Used as a callback by wp_list_comments() for displaying the comments.
     */
    function call_center_bpo_comment($comment, $args, $depth){

        if ('pingback' == $comment->comment_type || 'trackback' == $comment->comment_type) : ?>

            <li id="comment-<?php comment_ID(); ?>" <?php comment_class('media'); ?>>
            <div class="comment-body">
                <?php esc_html_e('Pingback:', 'call-center-bpo');
                comment_author_link(); ?><?php edit_comment_link(__('Edit', 'call-center-bpo'), '<span class="edit-link">', '</span>'); ?>
            </div>

        <?php else : ?>

        <li id="comment-<?php comment_ID(); ?>" <?php comment_class(empty($args['has_children']) ? '' : 'parent'); ?>>
            <article id="div-comment-<?php comment_ID(); ?>" class="comment-body media mb-4">
                <a class="pull-left" href="#">
                    <?php if (0 != $args['avatar_size']) echo get_avatar($comment, $args['avatar_size']); ?>
                </a>
                <div class="media-body">
                    <div class="media-body-wrap card">
                        <div class="card-header">
                            <h5 class="mt-0"><?php /* translators: %s: author */ printf('<cite class="fn">%s</cite>', get_comment_author_link() ); ?></h5>
                            <div class="comment-meta">
                                <a href="<?php echo esc_url(get_comment_link($comment->comment_ID)); ?>">
                                    <time datetime="<?php comment_time('c'); ?>">
                                        <?php /* translators: %s: Date */ printf( esc_html__('%1$s at %2$s', 'call-center-bpo'), esc_html( get_comment_date() ), esc_html( get_comment_time() ) ); ?>
                                    </time>
                                </a>
                                <?php edit_comment_link( __( 'Edit', 'call-center-bpo' ), '<span class="edit-link">', '</span>' ); ?>
                            </div>
                        </div>

                        <?php if ('0' == $comment->comment_approved) : ?>
                            <p class="comment-awaiting-moderation"><?php esc_html_e('Your comment is awaiting moderation.', 'call-center-bpo'); ?></p>
                        <?php endif; ?>

                        <div class="comment-content card-block">
                            <?php comment_text(); ?>
                        </div>

                        <?php comment_reply_link(
                            array_merge(
                                $args, array(
                                    'add_below' => 'div-comment',
                                    'depth' => $depth,
                                    'max_depth' => $args['max_depth'],
                                    'before' => '<footer class="reply comment-reply card-footer">',
                                    'after' => '</footer><!-- .reply -->'
                                )
                            )
                        ); ?>
                    </div>
                </div>
            </article>

            <?php
        endif;
    }
endif; // ends check for call_center_bpo_comment()

if (!function_exists('call_center_bpo_widgets_init')) {

	function call_center_bpo_widgets_init() {

		register_sidebar(array(

			'name' => esc_html__('Sidebar','call-center-bpo'),
			'id'   => 'call-center-bpo-sidebar',
			'description'   => esc_html__('This sidebar will be shown next to the content.', 'call-center-bpo'),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="title">',
			'after_title'   => '</h4>'

		));

		register_sidebar(array(

			'name' => esc_html__('Sidebar 2','call-center-bpo'),
			'id'   => 'call-center-bpo-sidebar-2',
			'description'   => esc_html__('This sidebar will be shown next to the content.', 'call-center-bpo'),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="title">',
			'after_title'   => '</h4>'

		));

		register_sidebar(array(

			'name' => esc_html__('Sidebar 3','call-center-bpo'),
			'id'   => 'call-center-bpo-sidebar-3',
			'description'   => esc_html__('This sidebar will be shown next to the content.', 'call-center-bpo'),
			'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="title">',
			'after_title'   => '</h4>'

		));


		register_sidebar(array(

			'name' => esc_html__('Footer sidebar','call-center-bpo'),
			'id'   => 'call-center-bpo-footer-sidebar',
			'description'   => esc_html__('This sidebar will be shown next at the bottom of your content.', 'call-center-bpo'),
			'before_widget' => '<div id="%1$s" class="col-lg-3 col-md-3 %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="title">',
			'after_title'   => '</h4>'

		));

	}

	add_action( 'widgets_init', 'call_center_bpo_widgets_init' );

}

function call_center_bpo_get_categories_select() {
	$teh_cats = get_categories();
	$results = array();
	$count = count($teh_cats);
	for ($i=0; $i < $count; $i++) {
	if (isset($teh_cats[$i]))
  		$results[$teh_cats[$i]->slug] = $teh_cats[$i]->name;
	else
  		$count++;
	}
	return $results;
}

function call_center_bpo_sanitize_phone_number( $phone ) {
	return preg_replace( '/[^\d+]/', '', $phone );
}

// Change number or products per row to 3
add_filter('loop_shop_columns', 'call_center_bpo_loop_columns');
if (!function_exists('call_center_bpo_loop_columns')) {
	function call_center_bpo_loop_columns() {
		$call_center_bpo_columns = get_theme_mod( 'call_center_bpo_per_columns', 3 );
		return $call_center_bpo_columns;
	}
}

//Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'call_center_bpo_per_page', 20 );
function call_center_bpo_per_page( $call_center_bpo_cols ) {
  	$call_center_bpo_cols = get_theme_mod( 'call_center_bpo_product_per_page', 9 );
	return $call_center_bpo_cols;
}

// Add filter to modify the number of related products
add_filter( 'woocommerce_output_related_products_args', 'call_center_bpo_products_args' );
function call_center_bpo_products_args( $args ) {
    $args['posts_per_page'] = get_theme_mod( 'custom_related_products_number', 6 );
    $args['columns'] = get_theme_mod( 'custom_related_products_number_per_row', 3 );
    return $args;
}

add_action('after_switch_theme', 'call_center_bpo_setup_options');
function call_center_bpo_setup_options () {
    update_option('dismissed-get_started', FALSE );
}

/*-----------------------------------------------------------------------------------*/
/* Enqueue Global color style */
/*-----------------------------------------------------------------------------------*/
function call_center_bpo_global_color() {

    $call_center_bpo_theme_color_css = '';
    $call_center_bpo_global_color = get_theme_mod('call_center_bpo_global_color');
    $call_center_bpo_global_color_2 = get_theme_mod('call_center_bpo_global_color_2');
    $call_center_bpo_copyright_bg = get_theme_mod('call_center_bpo_copyright_bg');

	$call_center_bpo_theme_color_css = '
		.phone-box i,#main-menu ul.children ,#main-menu ul.sub-menu,p.slider-button a,.slider button.owl-prev i, .slider button.owl-next i,.scroll-up a,.woocommerce nav.woocommerce-pagination ul li span.current,.pagination .nav-links a:hover,.pagination .nav-links a:focus,.pagination .nav-links span.current,.call-center-bpo-pagination span.current,.call-center-bpo-pagination span.current:hover,.call-center-bpo-pagination span.current:focus,.call-center-bpo-pagination a span:hover,.call-center-bpo-pagination a span:focus ,.comment-respond input#submit,.comment-reply a,.sidebar-area h4.title, .sidebar-area h1.wp-block-heading,.sidebar-area h2.wp-block-heading,.sidebar-area h3.wp-block-heading,.sidebar-area h4.wp-block-heading,.sidebar-area h5.wp-block-heading,.sidebar-area h6.wp-block-heading,.sidebar-area .wp-block-search__label,.sidebar-area .wp-block-search__button,.sidebar-area .tagcloud a, p.wp-block-tag-cloud a,.searchform input[type=submit], .sidebar-area .wp-block-search__button,nav.woocommerce-MyAccount-navigation ul li,.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.woocommerce a.added_to_cart,.wp-block-woocommerce-cart .wc-block-cart__submit-button, .wc-block-components-checkout-place-order-button, .wc-block-components-totals-coupon__button,.wp-block-woocommerce-cart .wc-block-components-product-badge,.triangle35b:nth-child(1),.triangle35b:nth-child(3){
		background: '.esc_attr($call_center_bpo_global_color).';
		}
		@media screen and (min-width: 320px) and (max-width: 767px) {
		    .menu-toggle, .dropdown-toggle,button.close-menu{
		        background: '.esc_attr($call_center_bpo_global_color).';
		    }
		}
		.searchform input[type=submit]:hover,.searchform input[type=submit]:focus{
		background-color: '.esc_attr($call_center_bpo_global_color).';
		}
		a:hover,a:focus,.post-single a, .page-single a,.sidebar-area .textwidget a,.comment-content a,.woocommerce-product-details__short-description a,#tab-description a,.extra-home-content a,.social-links i:hover,#main-menu a:hover,#main-menu ul li a:hover,#main-menu li:hover > a,#main-menu a:focus,#main-menu ul li a:focus,#main-menu li.focus > a,#main-menu li:focus > a,#main-menu ul li.current-menu-item > a,#main-menu ul li.current_page_item > a,#main-menu ul li.current-menu-parent > a,#main-menu ul li.current_page_ancestor > a,#main-menu ul li.current-menu-ancestor > a,.post-meta i,.blog_box h5,.services_box a,#services h6,.bread_crumb a:hover,.bread_crumb span,.woocommerce ul.products li.product .price,.woocommerce div.product p.price, .woocommerce div.product span.price{
			color: '.esc_attr($call_center_bpo_global_color).';
		}
		p.slider-button a:hover,.slider button.owl-prev i:hover, .slider button.owl-next i:hover,#services,.comment-respond input#submit:hover,.comment-reply a:hover,.sidebar-area .tagcloud a:hover,nav.woocommerce-MyAccount-navigation ul li:hover,.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover,.woocommerce a.added_to_cart:hover,.woocommerce ul.products li.product .onsale, .woocommerce span.onsale,#site-navigation{
			background: '.esc_attr($call_center_bpo_global_color_2).';
		}
		h1,h2,h3,h4,h5,h6,.phone-box h6,.page-template-frontpage .logo a,.page-template-frontpage .logo span,.page-template-frontpage #main-menu ul li a,#main-menu ul.children li a:hover,#main-menu ul.sub-menu li a:hover,pre,.blog_box h3,.blog_box p,{
			color: '.esc_attr($call_center_bpo_global_color_2).';
		}
		.sidebar-area select,.sidebar-area textarea, #comments textarea,.sidebar-area input[type="text"], #comments input[type="text"],.sidebar-area input[type="password"],.sidebar-area input[type="datetime"],.sidebar-area input[type="datetime-local"],.sidebar-area input[type="date"],.sidebar-area input[type="month"],.sidebar-area input[type="time"],.sidebar-area input[type="week"],.sidebar-area input[type="number"],.sidebar-area input[type="email"],.sidebar-area input[type="url"],.sidebar-area input[type="search"],.sidebar-area input[type="tel"],.sidebar-area input[type="color"],.sidebar-area .uneditable-input,#comments input[type="email"],#comments input[type="url"],nav.woocommerce-MyAccount-navigation ul li:hover,.sidebar-area h4.title, .sidebar-area h1.wp-block-heading, .sidebar-area h2.wp-block-heading, .sidebar-area h3.wp-block-heading, .sidebar-area h4.wp-block-heading, .sidebar-area h5.wp-block-heading, .sidebar-area h6.wp-block-heading, .sidebar-area .wp-block-search__label{
			border-color: '.esc_attr($call_center_bpo_global_color_2).';
		}
    	.copyright {
			background: '.esc_attr($call_center_bpo_copyright_bg).';
		}
	';
    wp_add_inline_style( 'call-center-bpo-style',$call_center_bpo_theme_color_css );
    wp_add_inline_style( 'call-center-bpo-woocommerce-css',$call_center_bpo_theme_color_css );

}
add_action( 'wp_enqueue_scripts', 'call_center_bpo_global_color' );

//add animation class
if ( class_exists( 'WooCommerce' ) ) { 
	add_filter('post_class', function($call_center_bpo, $class, $product_id) {
	    if( is_shop() || is_product_category() ){
	        
	        $call_center_bpo = array_merge(['wow','zoomIn'], $call_center_bpo);
	    }
	    return $call_center_bpo;
	},10,3);
}

add_action( 'customize_register', 'call_center_bpo_remove_setting', 20 );
function call_center_bpo_remove_setting( $wp_customize ) {
    // Check if the setting or control exists before removing
    if ( $wp_customize->get_setting( 'header_textcolor' ) ) {
        $wp_customize->remove_setting( 'header_textcolor' );
    }

    if ( $wp_customize->get_control( 'header_textcolor' ) ) {
        $wp_customize->remove_control( 'header_textcolor' );
    }
}

// edit link option
if (!function_exists('call_center_bpo_edit_link')) :

    function call_center_bpo_edit_link($view = 'default')
    {
        global $post;
            edit_post_link(
                sprintf(
                    wp_kses(
                    /* translators: %s: Name of current post. Only visible to screen readers */
                        __('Edit <span class="screen-reader-text">%s</span>', 'call-center-bpo'),
                        array(
                            'span' => array(
                                'class' => array(),
                            ),
                        )
                    ),
                    get_the_title()
                ),
                '<span class="edit-link"><i class="fas fa-edit"></i>',
                '</span>'
            );

    }
endif;?>