<?php if ( get_theme_mod('call_center_bpo_blog_box_enable',false) ) : ?>

<?php $call_center_bpo_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('call_center_bpo_blog_slide_category'),
  'posts_per_page' => get_theme_mod('call_center_bpo_blog_slide_number'),
); ?>

<div class="slider">
  <div class="owl-carousel">
    <?php $call_center_bpo_arr_posts = new WP_Query( $call_center_bpo_args );
    if ( $call_center_bpo_arr_posts->have_posts() ) :
      while ( $call_center_bpo_arr_posts->have_posts() ) :
        $call_center_bpo_arr_posts->the_post();
        ?>
        <div class="blog_inner_box">
          <?php
            if ( has_post_thumbnail() ) :
              the_post_thumbnail();
            else:
              ?>
              <div class="slider-alternate">
                <img src="<?php echo get_stylesheet_directory_uri() . '/assets/images/banner.png'; ?>">
              </div>
              <?php
            endif;
          ?>
          <div class="blog_box pt-3 pt-md-0 wow zoomIn">
            <?php if ( get_theme_mod('call_center_bpo_title_unable_disable',true) ) : ?>
              <h3 class="my-3"><?php the_title(); ?></a></h3>
            <?php endif; ?>
            <p class="mb-0"><?php echo wp_trim_words( get_the_content(), 20 ); ?></p>
            <?php if ( get_theme_mod('call_center_bpo_button_unable_disable',true) ) : ?>
              <p class="slider-button mt-4">
                <a class="slide-btn-1" href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('View More','call-center-bpo'); ?></a>
                <?php if( get_theme_mod( 'call_center_bpo_slider_button_2_link' ) != '') { ?>
                <a class="slide-btn-2" href="<?php echo esc_url( get_theme_mod( 'call_center_bpo_slider_button_2_link','' ) ); ?>"><?php esc_html_e('Start Free Trial','call-center-bpo'); ?></a>
                <?php } ?>
              </p>
            <?php endif; ?>
          </div>
          <div class="phone-box wow fadeInUp">
            <?php if ( get_theme_mod('call_center_bpo_header_phone_text') || get_theme_mod('call_center_bpo_header_phone_number') ) : ?>
              <div class="first-box">
                <div class="row">
                  <div class="col-lg-3 col-md-3 col-sm-3 align-self-center">
                    <i class="fas fa-phone"></i>
                  </div>
                  <div class="col-lg-9 col-md-9 col-sm-9 align-self-center">
                    <h6><?php echo esc_html( get_theme_mod('call_center_bpo_header_phone_text' ) ); ?></h6>
                    <p class="mb-0"><a href="callto:<?php echo esc_html(get_theme_mod('call_center_bpo_header_phone_number','')); ?>"><?php echo esc_html(get_theme_mod('call_center_bpo_header_phone_number','')); ?></a></p>
                  </div>
                </div>
              </div>
            <?php endif; ?>
          </div>
        </div>
      <?php
    endwhile;
    wp_reset_postdata();
    endif; ?>
  </div>
</div>

<?php endif; ?>
