<?php if ( get_theme_mod('call_center_bpo_services_enable',false) ) : ?>

<?php $call_center_bpo_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('call_center_bpo_services_category'),
  'posts_per_page' => get_theme_mod('call_center_bpo_services_number'),
); ?>

<div id="services" class="py-5">
  <div class="container">
    <?php if ( get_theme_mod('call_center_bpo_services_short_heading') || get_theme_mod('call_center_bpo_services_heading') ) : ?>
      <h6 class="text-center"><?php echo esc_html( get_theme_mod('call_center_bpo_services_short_heading' ) ); ?></h6>
      <h3 class="text-center mb-5"><?php echo esc_html( get_theme_mod('call_center_bpo_services_heading' ) ); ?></h3>
    <?php endif; ?>
    <div class="row">
      <?php $call_center_bpo_arr_posts = new WP_Query( $call_center_bpo_args );
      if ( $call_center_bpo_arr_posts->have_posts() ) :
        while ( $call_center_bpo_arr_posts->have_posts() ) :
          $call_center_bpo_arr_posts->the_post();
          ?>
          <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="services_inner_box mb-3 wow zoomIn">
              <?php
                if ( has_post_thumbnail() ) :
                  the_post_thumbnail();
                else:
                  ?>
                  <div class="slider-alternate">
                    <img src="<?php echo get_stylesheet_directory_uri() . '/assets/images/banner.png'; ?>">
                  </div>
                  <?php
                endif;
              ?>
              <div class="services_box pt-3 pt-md-0">
                <?php if ( get_theme_mod('call_center_bpo_title_unable_disable',true) ) : ?>
                  <h4 class="my-3"><?php the_title(); ?></a></h4>
                <?php endif; ?>
                <p><?php echo wp_trim_words( get_the_content(), 15 ); ?></p>
                <?php if ( get_theme_mod('call_center_bpo_button_unable_disable',true) ) : ?>
                <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Know More','call-center-bpo'); ?>  <i class="fas fa-angle-double-right"></i></a>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php
      endwhile;
      wp_reset_postdata();
      endif; ?>
    </div>
  </div>
</div>

<?php endif; ?>
