<?php

/**
* Get started notice
*/

add_action( 'wp_ajax_call_center_bpo_dismissed_notice_handler', 'call_center_bpo_ajax_notice_handler' );

function call_center_bpo_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function call_center_bpo_deprecated_hook_admin_notice() {
        if ( ! get_option('dismissed-get_started', FALSE ) ) { ?>

            <?php
            $current_screen = get_current_screen();
				if ( $current_screen->id !== 'appearance_page_call-center-bpo-guide-page' && $current_screen->id != 'migy_image_gallery_page_migy_templates' ) {
             $call_center_bpo_comments_theme = wp_get_theme(); ?>
            <div class="call-center-bpo-notice-wrapper updated notice notice-get-started-class is-dismissible" data-notice="get_started">
			<div class="call-center-bpo-notice">
				<div class="call-center-bpo-notice-img">
					<img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/admin-logo.png'); ?>" alt="<?php esc_attr_e('logo', 'call-center-bpo'); ?>">
				</div>
				<div class="call-center-bpo-notice-content">
					<div class="call-center-bpo-notice-heading"><?php esc_html_e('Thanks for installing ','call-center-bpo'); ?><?php echo esc_html( $call_center_bpo_comments_theme ); ?></div>
					<p><?php printf(__('In order to fully benefit from everything our theme has to offer, please make sure you visit our <a href="%s">For Premium Options</a>.', 'call-center-bpo'), esc_url(admin_url('themes.php?page=call-center-bpo-guide-page'))); ?></p>
				</div>
			</div>
		</div>
        <?php }
	}
}

add_action( 'admin_notices', 'call_center_bpo_deprecated_hook_admin_notice' );

add_action( 'admin_menu', 'call_center_bpo_getting_started' );
function call_center_bpo_getting_started() {
	add_theme_page( esc_html__('Get Started', 'call-center-bpo'), esc_html__('Get Started', 'call-center-bpo'), 'edit_theme_options', 'call-center-bpo-guide-page', 'call_center_bpo_test_guide');
}

function call_center_bpo_admin_enqueue_scripts() {
	wp_enqueue_style( 'call-center-bpo-admin-style', esc_url( get_template_directory_uri() ).'/css/main.css' );
	wp_enqueue_script( 'call-center-bpo-admin-script', get_template_directory_uri() . '/js/call-center-bpo-admin-script.js', array( 'jquery' ), '', true );
    wp_localize_script( 'call-center-bpo-admin-script', 'call_center_bpo_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
}
add_action( 'admin_enqueue_scripts', 'call_center_bpo_admin_enqueue_scripts' );

if ( ! defined( 'CALL_CENTER_BPO_DOCS_FREE' ) ) {
define('CALL_CENTER_BPO_DOCS_FREE',__('https://demo.misbahwp.com/docs/call-center-bpo-free-docs/','call-center-bpo'));
}
if ( ! defined( 'CALL_CENTER_BPO_DOCS_PRO' ) ) {
define('CALL_CENTER_BPO_DOCS_PRO',__('https://demo.misbahwp.com/docs/call-center-bpo-pro-docs/','call-center-bpo'));
}
if ( ! defined( 'CALL_CENTER_BPO_BUY_NOW' ) ) {
define('CALL_CENTER_BPO_BUY_NOW',__('https://www.misbahwp.com/products/bpo-company-wordpress-theme','call-center-bpo'));
}
if ( ! defined( 'CALL_CENTER_BPO_SUPPORT_FREE' ) ) {
define('CALL_CENTER_BPO_SUPPORT_FREE',__('https://wordpress.org/support/theme/call-center-bpo/','call-center-bpo'));
}
if ( ! defined( 'CALL_CENTER_BPO_REVIEW_FREE' ) ) {
define('CALL_CENTER_BPO_REVIEW_FREE',__('https://wordpress.org/support/theme/call-center-bpo/reviews/#new-post','call-center-bpo'));
}
if ( ! defined( 'CALL_CENTER_BPO_DEMO_PRO' ) ) {
define('CALL_CENTER_BPO_DEMO_PRO',__('https://demo.misbahwp.com/call-center-bpo/','call-center-bpo'));
}
if( ! defined( 'CALL_CENTER_BPO_THEME_BUNDLE' ) ) {
define('CALL_CENTER_BPO_THEME_BUNDLE',__('https://www.misbahwp.com/products/wordpress-bundle','call-center-bpo'));
}

function call_center_bpo_test_guide() { ?>
	<?php $call_center_bpo_theme = wp_get_theme(); ?>

	<div class="wrap" id="main-page">
		<div id="lefty">
			<div id="admin_links">
				<a href="<?php echo esc_url( CALL_CENTER_BPO_DOCS_FREE ); ?>" target="_blank" class="blue-button-1"><?php esc_html_e( 'Documentation', 'call-center-bpo' ) ?></a>
				<a href="<?php echo esc_url( admin_url('customize.php') ); ?>" id="customizer" target="_blank"><?php esc_html_e( 'Customize', 'call-center-bpo' ); ?> </a>
				<a class="blue-button-1" href="<?php echo esc_url( CALL_CENTER_BPO_SUPPORT_FREE ); ?>" target="_blank" class="btn3"><?php esc_html_e( 'Support', 'call-center-bpo' ) ?></a>
				<a class="blue-button-2" href="<?php echo esc_url( CALL_CENTER_BPO_REVIEW_FREE ); ?>" target="_blank" class="btn4"><?php esc_html_e( 'Review', 'call-center-bpo' ) ?></a>
			</div>
			<div id="description">
				<h3><?php esc_html_e('Welcome! Thank you for choosing ','call-center-bpo'); ?><?php echo esc_html( $call_center_bpo_theme ); ?>  <span><?php esc_html_e('Version: ', 'call-center-bpo'); ?><?php echo esc_html($call_center_bpo_theme['Version']);?></span></h3>
				<img class="img_responsive" style="width: 100%;" src="<?php echo esc_url( $call_center_bpo_theme->get_screenshot() ); ?>" />
				<div id="description-insidee">
					<?php
						$call_center_bpo_theme = wp_get_theme();
						echo wp_kses_post( apply_filters( 'misbah_theme_description', esc_html( $call_center_bpo_theme->get( 'Description' ) ) ) );
					?>
				</div>
			</div>
		</div>

		<div id="righty">
			<div class="postboxx donate">
				<h3 class="hndle"><?php esc_html_e( 'Upgrade to Premium', 'call-center-bpo' ); ?></h3>
				<div class="insidee">
					<p><?php esc_html_e('Discover upgraded pro features with premium version click to upgrade.','call-center-bpo'); ?></p>
					<div id="admin_pro_links">
						<a class="blue-button-2" href="<?php echo esc_url( CALL_CENTER_BPO_BUY_NOW ); ?>" target="_blank"><?php esc_html_e( 'Go Pro', 'call-center-bpo' ); ?></a>
						<a class="blue-button-1" href="<?php echo esc_url( CALL_CENTER_BPO_DEMO_PRO ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'call-center-bpo' ) ?></a>
						<a class="blue-button-2" href="<?php echo esc_url( CALL_CENTER_BPO_DOCS_PRO ); ?>" target="_blank"><?php esc_html_e( 'Pro Docs', 'call-center-bpo' ) ?></a>
					</div>
				</div>

				<h3 class="hndle bundle"><?php esc_html_e( 'Go For Theme Bundle', 'call-center-bpo' ); ?></h3>
				<div class="insidee theme-bundle">
					<p class="offer"><?php esc_html_e('Get 80+ Perfect WordPress Theme In A Single Package at just $89."','call-center-bpo'); ?></p>
					<p class="coupon"><?php esc_html_e('Get Our Theme Pack of 80+ WordPress Themes At 15% Off','call-center-bpo'); ?><span class="coupon-code"><?php esc_html_e('"Bundleup15"','call-center-bpo'); ?></span></p>
					<div id="admin_pro_linkss">
						<a class="blue-button-1" href="<?php echo esc_url( CALL_CENTER_BPO_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e( 'Theme Bundle', 'call-center-bpo' ) ?></a>
					</div>
				<div class="d-table">
			    <ul class="d-column">
			      <li class="feature"><?php esc_html_e('Features','call-center-bpo'); ?></li>
			      <li class="free"><?php esc_html_e('Pro','call-center-bpo'); ?></li>
			      <li class="plus"><?php esc_html_e('Free','call-center-bpo'); ?></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('24hrs Priority Support','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('LearnPress Campatiblity','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Kirki Framework','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Posttype','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('One Click Demo Import','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Reordering','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Enable / Disable Option','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Multiple Sections','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Color Pallete','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Widgets','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Page Templates','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Typography','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Background Image / Color ','call-center-bpo'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
	  		</div>
			</div>
		</div>
	</div>

<?php } ?>
