<?php

if ( class_exists("Kirki")){

	// LOGO

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'call_center_bpo_logo_resizer',
		'label'       => esc_html__( 'Adjust Your Logo Size ', 'call-center-bpo' ),
		'section'     => 'title_tagline',
		'default'     => 70,
		'choices'     => [
			'min'  => 10,
			'max'  => 300,
			'step' => 10,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_enable_logo_text',
		'section'     => 'title_tagline',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Site Title and Tagline', 'call-center-bpo' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'call_center_bpo_display_header_title',
		'label'       => esc_html__( 'Site Title Enable / Disable Button', 'call-center-bpo' ),
		'section'     => 'title_tagline',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'call-center-bpo' ),
			'off' => esc_html__( 'Disable', 'call-center-bpo' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'call_center_bpo_display_header_text',
		'label'       => esc_html__( 'Tagline Enable / Disable Button', 'call-center-bpo' ),
		'section'     => 'title_tagline',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'call-center-bpo' ),
			'off' => esc_html__( 'Disable', 'call-center-bpo' ),
		],
	] );

	// FONT STYLE TYPOGRAPHY

	Kirki::add_panel( 'call_center_bpo_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Typography', 'call-center-bpo' ),
	) );

	Kirki::add_section( 'call_center_bpo_font_style_section', array(
		'title'      => esc_html__( 'Typography Option',  'call-center-bpo' ),
		'priority'   => 2,
		'capability' => 'edit_theme_options',
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_font_style_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_all_headings_typography',
		'section'     => 'call_center_bpo_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading Of All Sections',  'call-center-bpo' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'call_center_bpo_all_headings_typography',
		'label'       => esc_html__( 'Heading Typography',  'call-center-bpo' ),
		'description' => esc_html__( 'Select the typography options for your heading.',  'call-center-bpo' ),
		'section'     => 'call_center_bpo_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'h1','h2','h3','h4','h5','h6', ),
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_body_content_typography',
		'section'     => 'call_center_bpo_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Body Content',  'call-center-bpo' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'call_center_bpo_body_content_typography',
		'label'       => esc_html__( 'Content Typography',  'call-center-bpo' ),
		'description' => esc_html__( 'Select the typography options for your content.',  'call-center-bpo' ),
		'section'     => 'call_center_bpo_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'body', ),
			),
		),
	) );

		// PANEL
	Kirki::add_panel( 'call_center_bpo_panel_id_5', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Animations', 'call-center-bpo' ),
	) );

	// ANIMATION SECTION
	Kirki::add_section( 'call_center_bpo_section_animation', array(
	    'title'          => esc_html__( 'Animations', 'call-center-bpo' ),
	    'priority'       => 2,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_section_animation',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'call_center_bpo_animation_enabled',
		'label'       => esc_html__( 'Turn To Show Animation', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_section_animation',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'call-center-bpo' ),
			'off' => esc_html__( 'Disable', 'call-center-bpo' ),
		],
	] );

	// PANEL
	Kirki::add_panel( 'call_center_bpo_panel_id_2', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Dark Mode', 'call-center-bpo' ),
	) );

	// DARK MODE SECTION
	Kirki::add_section( 'call_center_bpo_section_dark_mode', array(
	    'title'          => esc_html__( 'Dark Mode', 'call-center-bpo' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_section_dark_mode',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'call_center_bpo_dark_colors',
	    'section'     => 'call_center_bpo_section_dark_mode',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Dark Appearance', 'call-center-bpo' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'call_center_bpo_is_dark_mode_enabled',
		'label'       => esc_html__( 'Turn To Dark Mode', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_section_dark_mode',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'call-center-bpo' ),
			'off' => esc_html__( 'Disable', 'call-center-bpo' ),
		],
	] );


	// PANEL
	Kirki::add_panel( 'call_center_bpo_panel_id_3', array(
	    'priority'    => 10,
	    'title'       => esc_html__( '404 Settings', 'call-center-bpo' ),
	) );

	// 404 SECTION
	Kirki::add_section( 'call_center_bpo_section_404', array(
	    'title'          => esc_html__( '404 Settings', 'call-center-bpo' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_section_404',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'call_center_bpo_not_found_heading',
	    'section'     => 'call_center_bpo_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Not Found Heading', 'call-center-bpo' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'call_center_bpo_404_page_title',
		'section'  => 'call_center_bpo_section_404',
		'default'  => esc_html__('404 Not Found', 'call-center-bpo'),
		'priority' => 10,
	] );

		Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'call_center_bpo_not_found_text',
	    'section'     => 'call_center_bpo_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Not Found Content', 'call-center-bpo' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'call_center_bpo_404_page_content',
		'section'  => 'call_center_bpo_section_404',
		'default'  => esc_html__('Sorry, no posts matched your criteria.', 'call-center-bpo'),
		'priority' => 10,
	] );
	// PANEL

	Kirki::add_panel( 'call_center_bpo_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Options', 'call-center-bpo' ),
	) );

	// COLOR SECTION

	Kirki::add_section( 'call_center_bpo_section_color', array(
	    'title'          => esc_html__( 'Global Color', 'call-center-bpo' ),
	    'panel'          => 'call_center_bpo_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
		'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_section_color',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_global_colors',
		'section'     => 'call_center_bpo_section_color',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Here you can change your theme color on one click.', 'call-center-bpo' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'call_center_bpo_global_color',
		'label'       => __( 'choose your Appropriate Color', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_section_color',
		'default'     => '#9183ef',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'call_center_bpo_global_color_2',
		'label'       => __( 'Choose Your Second Color', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_section_color',
		'default'     => '#2c233d',
	] );


	// Additional Settings

	Kirki::add_section( 'call_center_bpo_additional_settings', array(
	    'title'          => esc_html__( 'Additional Settings', 'call-center-bpo' ),
	    'panel'          => 'call_center_bpo_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_additional_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'call_center_bpo_scroll_enable_setting',
		'label'       => esc_html__( 'Here you can enable or disable your scroller.', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_additional_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	new \Kirki\Field\Radio_Buttonset([
		'settings'    => 'call_center_bpo_scroll_top_position',
		'label'       => esc_html__( 'Alignment for Scroll To Top', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_additional_settings',
		'default'     => 'Right',
		'priority'    => 10,
		'choices'     => [
			'Left'   => esc_html__( 'Left', 'call-center-bpo' ),
			'Center' => esc_html__( 'Center', 'call-center-bpo' ),
			'Right'  => esc_html__( 'Right', 'call-center-bpo' ),
		],
	]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'dashicons',
		'settings' => 'call_center_bpo_scroll_top_icon',
		'label'    => esc_html__( 'Select Appropriate Scroll Top Icon', 'call-center-bpo' ),
		'section'  => 'call_center_bpo_additional_settings',
		'default'  => 'dashicons dashicons-arrow-up-alt',
		'priority' => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'menu_text_transform_call_center_bpo',
		'label'       => esc_html__( 'Menus Text Transform', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_additional_settings',
		'default'     => 'CAPITALISE',
		'placeholder' => esc_html__( 'Choose an option', 'call-center-bpo' ),
		'choices'     => [
			'CAPITALISE' => esc_html__( 'CAPITALISE', 'call-center-bpo' ),
			'UPPERCASE' => esc_html__( 'UPPERCASE', 'call-center-bpo' ),
			'LOWERCASE' => esc_html__( 'LOWERCASE', 'call-center-bpo' ),

		],
	]
	);

	new \Kirki\Field\Select(
	[
		'settings'    => 'call_center_bpo_menu_zoom',
		'label'       => esc_html__( 'Menu Transition', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_additional_settings',
		'default' => 'None',
		'placeholder' => esc_html__( 'Choose an option', 'call-center-bpo' ),
		'choices'     => [
			'None' => __('None','call-center-bpo'),
            'Zoominn' => __('Zoom Inn','call-center-bpo'),
            
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'call_center_bpo_container_width',
		'label'       => esc_html__( 'Theme Container Width', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_additional_settings',
		'default'     => 100,
		'choices'     => [
			'min'  => 50,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'call_center_bpo_site_loader',
		'label'       => esc_html__( 'Here you can enable or disable your Site Loader.', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'call_center_bpo_preloader_type',
		'label'       => esc_html__( 'Preloader Type', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_additional_settings',
		'default' => 'four-way-loader',
		'placeholder' => esc_html__( 'Choose an option', 'call-center-bpo' ),
		'choices'     => [
			'four-way-loader' => __('Type 1','call-center-bpo'),
            'cube-loader' => __('Type 2','call-center-bpo'),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'call_center_bpo_sticky_header',
		'label'       => esc_html__( 'Here you can enable or disable your Sticky Header.', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'call_center_bpo_page_layout',
		'label'       => esc_html__( 'Page Layout Setting', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_additional_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'call-center-bpo' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','call-center-bpo'),
            'Right Sidebar' => __('Right Sidebar','call-center-bpo'),
            'One Column' => __('One Column','call-center-bpo')
		],
	] );

	// POST SECTION

	Kirki::add_section( 'call_center_bpo_section_post', array(
	    'title'          => esc_html__( 'Post Settings', 'call-center-bpo' ),
	    'panel'          => 'call_center_bpo_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_section_post',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
	] );

	new \Kirki\Field\Sortable(
	[
		'settings' => 'call_center_bpo_archive_element_sortable',
		'label'    => __( 'Archive Post Page element Reordering', 'call-center-bpo' ),
		'section'  => 'call_center_bpo_section_post',
		'default'  => [ 'option1', 'option2', 'option3' ],
		'choices'  => [
			'option1' => esc_html__( 'Post Meta', 'call-center-bpo' ),
			'option2' => esc_html__( 'Post Title', 'call-center-bpo' ),
			'option3' => esc_html__( 'Post Content', 'call-center-bpo' ),
		],
	]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'call_center_bpo_post_excerpt_number',
		'label'       => esc_html__( 'Post Content Range', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_section_post',
		'default'     => 15,
		'choices'     => [
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'call_center_bpo_pagination_setting',
		'label'       => esc_html__( 'Here you can enable or disable your Pagination.', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_section_post',
		'default'     => true,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'call_center_bpo_archive_sidebar_layout',
		'label'       => esc_html__( 'Archive Post Sidebar Layout Setting', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'call-center-bpo' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','call-center-bpo'),
            'Right Sidebar' => __('Right Sidebar','call-center-bpo'),
            'Three Column' => __('Three Column','call-center-bpo'),
            'Four Column' => __('Four Column','call-center-bpo'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','call-center-bpo'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','call-center-bpo'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','call-center-bpo')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'call_center_bpo_single_post_sidebar_layout',
		'label'       => esc_html__( 'Single Post Sidebar Layout Setting', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'call-center-bpo' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','call-center-bpo'),
            'Right Sidebar' => __('Right Sidebar','call-center-bpo'),
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'call_center_bpo_search_sidebar_layout',
		'label'       => esc_html__( 'Search Page Sidebar Layout Setting', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'call-center-bpo' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','call-center-bpo'),
            'Right Sidebar' => __('Right Sidebar','call-center-bpo'),
            'Three Column' => __('Three Column','call-center-bpo'),
            'Four Column' => __('Four Column','call-center-bpo'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','call-center-bpo'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','call-center-bpo'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','call-center-bpo')
		],
	] );

		// Breadcrumb
	Kirki::add_section( 'call_center_bpo_bradcrumb', array(
	    'title'          => esc_html__( 'Breadcrumb Settings', 'call-center-bpo' ),
	    'panel'          => 'call_center_bpo_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_bradcrumb',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
	] );

	 Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_enable_breadcrumb_heading',
		'section'     => 'call_center_bpo_bradcrumb',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Single Page Breadcrumb', 'call-center-bpo' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'call_center_bpo_breadcrumb_enable',
		'label'       => esc_html__( 'Breadcrumb Enable / Disable', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_bradcrumb',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'call-center-bpo' ),
			'off' => esc_html__( 'Disable', 'call-center-bpo' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'default'     => '/',
        'settings' => 'call_center_bpo_breadcrumb_separator' ,
        'label'    => esc_html__( 'Breadcrumb Separator',  'call-center-bpo' ),
        'section'  => 'call_center_bpo_bradcrumb',
    ] );

	
	if ( class_exists("woocommerce")){

	Kirki::add_section( 'call_center_bpo_woocommerce_settings', array(
		'title'          => esc_html__( 'Woocommerce Settings', 'call-center-bpo' ),
		'panel'          => 'call_center_bpo_panel_id',
		'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_woocommerce_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'call_center_bpo_shop_sidebar',
		'label'       => esc_html__( 'Here you can enable or disable shop page sidebar.', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'call_center_bpo_product_sidebar',
		'label'       => esc_html__( 'Here you can enable or disable product page sidebar.', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'call_center_bpo_related_product_setting',
		'label'       => esc_html__( 'Here you can enable or disable your related products.', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_woocommerce_settings',
		'default'     => true,
		'priority'    => 10,
	] );

	new \Kirki\Field\Number(
		[
			'settings' => 'call_center_bpo_per_columns',
			'label'    => esc_html__( 'Product Per Row', 'call-center-bpo' ),
			'section'  => 'call_center_bpo_woocommerce_settings',
			'default'  => 3,
			'choices'  => [
				'min'  => 1,
				'max'  => 4,
				'step' => 1,
			],
		]
	);

	new \Kirki\Field\Number(
		[
			'settings' => 'call_center_bpo_product_per_page',
			'label'    => esc_html__( 'Product Per Page', 'call-center-bpo' ),
			'section'  => 'call_center_bpo_woocommerce_settings',
			'default'  => 9,
			'choices'  => [
				'min'  => 1,
				'max'  => 15,
				'step' => 1,
			],
		]
	);

	new \Kirki\Field\Number(
	[
		'settings' => 'custom_related_products_number_per_row',
		'label'    => esc_html__( 'Related Product Per Column', 'call-center-bpo' ),
		'section'  => 'call_center_bpo_woocommerce_settings',
		'default'  => 3,
		'choices'  => [
			'min'  => 1,
			'max'  => 4,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Number(
	[
		'settings' => 'custom_related_products_number',
		'label'    => esc_html__( 'Related Product Per Page', 'call-center-bpo' ),
		'section'  => 'call_center_bpo_woocommerce_settings',
		'default'  => 3,
		'choices'  => [
			'min'  => 1,
			'max'  => 10,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Select(
	[
		'settings'    => 'call_center_bpo_shop_page_layout',
		'label'       => esc_html__( 'Shop Page Layout Setting', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_woocommerce_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'call-center-bpo' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','call-center-bpo'),
            'Right Sidebar' => __('Right Sidebar','call-center-bpo')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'call_center_bpo_product_page_layout',
		'label'       => esc_html__( 'Product Page Layout Setting', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_woocommerce_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'call-center-bpo' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','call-center-bpo'),
            'Right Sidebar' => __('Right Sidebar','call-center-bpo')
		],
	] );

	new \Kirki\Field\Radio_Buttonset(
	[
		'settings'    => 'call_center_bpo_woocommerce_pagination_position',
		'label'       => esc_html__( 'Woocommerce Pagination Alignment', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_woocommerce_settings',
		'default'     => 'Center',
		'priority'    => 10,
		'choices'     => [
			'Left'   => esc_html__( 'Left', 'call-center-bpo' ),
			'Center' => esc_html__( 'Center', 'call-center-bpo' ),
			'Right'  => esc_html__( 'Right', 'call-center-bpo' ),
		],
	]
	);
}

	// HEADER SECTION

	Kirki::add_section( 'call_center_bpo_header_section', array(
        'title'          => esc_html__( ' Header Settings', 'call-center-bpo' ),
        'panel'          => 'call_center_bpo_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_header_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_header_button_heading',
		'section'     => 'call_center_bpo_header_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Add Button', 'call-center-bpo' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'    => esc_html__( 'Text', 'call-center-bpo' ),
		'settings' => 'call_center_bpo_header_button_text',
		'section'  => 'call_center_bpo_header_section',
		'default'  => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'url',
		'label'    => esc_html__( 'Link', 'call-center-bpo' ),
		'settings' => 'call_center_bpo_header_button_url',
		'section'  => 'call_center_bpo_header_section',
		'default'  => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_enable_socail_link',
		'section'     => 'call_center_bpo_header_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'call-center-bpo' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'call_center_bpo_header_section',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Social Icon', 'call-center-bpo' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'call-center-bpo' ),
		'settings'     => 'call_center_bpo_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'call-center-bpo' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'call-center-bpo' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'call-center-bpo' ),
				'description' => esc_html__( 'Add the social icon url here.', 'call-center-bpo' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );

	// SLIDER SECTION

	Kirki::add_section( 'call_center_bpo_blog_slide_section', array(
        'title'          => esc_html__( ' Slider Settings', 'call-center-bpo' ),
        'panel'          => 'call_center_bpo_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_blog_slide_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_enable_heading',
		'section'     => 'call_center_bpo_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Slider', 'call-center-bpo' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'call_center_bpo_blog_box_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_blog_slide_section',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'call-center-bpo' ),
			'off' => esc_html__( 'Disable', 'call-center-bpo' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'call_center_bpo_title_unable_disable',
		'label'       => esc_html__( 'Slide Title Enable / Disable', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_blog_slide_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'call-center-bpo' ),
			'off' => esc_html__( 'Disable', 'call-center-bpo' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'call_center_bpo_button_unable_disable',
		'label'       => esc_html__( 'Slide Button Enable / Disable', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_blog_slide_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'call-center-bpo' ),
			'off' => esc_html__( 'Disable', 'call-center-bpo' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_slider_heading',
		'section'     => 'call_center_bpo_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Slider', 'call-center-bpo' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'settings'    => 'call_center_bpo_blog_slide_number',
		'label'       => esc_html__( 'Number of slides to show', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_blog_slide_section',
		'default'     => 0,
		'choices'     => [
			'min'  => 1,
			'max'  => 3,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'select',
		'settings'    => 'call_center_bpo_blog_slide_category',
		'label'       => esc_html__( 'Select the category to show slider ( Image Dimension 1600 x 600 )', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_blog_slide_section',
		'default'     => '',
		'placeholder' => esc_html__( 'Select an category...', 'call-center-bpo' ),
		'priority'    => 10,
		'choices'     => call_center_bpo_get_categories_select(),
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'url',
		'label'    => esc_html__( 'Slider Button 2 Link', 'call-center-bpo' ),
		'settings' => 'call_center_bpo_slider_button_2_link',
		'section'  => 'call_center_bpo_blog_slide_section',
		'default'  => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_header_phone_number_heading',
		'section'     => 'call_center_bpo_blog_slide_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Add Phone Number', 'call-center-bpo' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'    => esc_html__( 'Text', 'call-center-bpo' ),
		'settings' => 'call_center_bpo_header_phone_text',
		'section'  => 'call_center_bpo_blog_slide_section',
		'default'  => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'    => esc_html__( 'Phone Number', 'call-center-bpo' ),
		'settings' => 'call_center_bpo_header_phone_number',
		'section'  => 'call_center_bpo_blog_slide_section',
		'default'  => '',
		'sanitize_callback' => 'call_center_bpo_sanitize_phone_number',
	] );

	new \Kirki\Field\Select([
		'settings'    => 'call_center_bpo_slider_content_alignment',
		'label'       => esc_html__( 'Slider Content Alignment', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_blog_slide_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'call-center-bpo' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'call-center-bpo' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'call-center-bpo' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'call-center-bpo' ),

		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'call_center_bpo_slider_opacity_color',
		'label'       => esc_html__( 'Slider Opacity Option', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_blog_slide_section',
		'default'     => '0.5',
		'placeholder' => esc_html__( 'Choose an option', 'call-center-bpo' ),
		'choices'     => [
			'0' => esc_html__( '0', 'call-center-bpo' ),
			'0.1' => esc_html__( '0.1', 'call-center-bpo' ),
			'0.2' => esc_html__( '0.2', 'call-center-bpo' ),
			'0.3' => esc_html__( '0.3', 'call-center-bpo' ),
			'0.4' => esc_html__( '0.4', 'call-center-bpo' ),
			'0.5' => esc_html__( '0.5', 'call-center-bpo' ),
			'0.6' => esc_html__( '0.6', 'call-center-bpo' ),
			'0.7' => esc_html__( '0.7', 'call-center-bpo' ),
			'0.8' => esc_html__( '0.8', 'call-center-bpo' ),
			'0.9' => esc_html__( '0.9', 'call-center-bpo' ),
			'unset' => esc_html__( 'Unset', 'call-center-bpo' ),
			

		],
	] );

	 Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'call_center_bpo_overlay_option',
		'label'       => esc_html__( 'Enable / Disable Slider Overlay', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_blog_slide_section',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'call-center-bpo' ),
			'off' => esc_html__( 'Disable', 'call-center-bpo' ),
		],
	] );

	 Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'call_center_bpo_slider_image_overlay_color',
		'label'       => __( 'choose your Appropriate Overlay Color', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_blog_slide_section',
		'default'     => '',
	] );


	// SERVICES SECTION

	Kirki::add_section( 'call_center_bpo_services_section', array(
        'title'          => esc_html__( 'Services Settings', 'call-center-bpo' ),
        'panel'          => 'call_center_bpo_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_services_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_enable_heading',
		'section'     => 'call_center_bpo_services_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Services', 'call-center-bpo' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'call_center_bpo_services_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_services_section',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'call-center-bpo' ),
			'off' => esc_html__( 'Disable', 'call-center-bpo' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_services_shot_title_heading',
		'section'     => 'call_center_bpo_services_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Add Short Heading', 'call-center-bpo' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'call_center_bpo_services_short_heading',
		'section'  => 'call_center_bpo_services_section',
		'default'  => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_services_title_heading',
		'section'     => 'call_center_bpo_services_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Add Heading', 'call-center-bpo' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'call_center_bpo_services_heading',
		'section'  => 'call_center_bpo_services_section',
		'default'  => '',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_slider_heading',
		'section'     => 'call_center_bpo_services_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Services', 'call-center-bpo' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'settings'    => 'call_center_bpo_services_number',
		'label'       => esc_html__( 'Number of services to show', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_services_section',
		'default'     => 0,
		'choices'     => [
			'min'  => 1,
			'max'  => 10,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'select',
		'settings'    => 'call_center_bpo_services_category',
		'section'     => 'call_center_bpo_services_section',
		'default'     => '',
		'placeholder' => esc_html__( 'Select an category...', 'call-center-bpo' ),
		'priority'    => 10,
		'choices'     => call_center_bpo_get_categories_select(),
	] );


	// FOOTER SECTION

	Kirki::add_section( 'call_center_bpo_footer_section', array(
        'title'          => esc_html__( 'Footer Settings', 'call-center-bpo' ),
        'panel'          => 'call_center_bpo_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'call-center-bpo' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( CALL_CENTER_BPO_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'call-center-bpo' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'call_center_bpo_footer_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'call-center-bpo' ) . '</div>',
	] );


  Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'call_center_bpo_footer_enable_heading',
	'section'     => 'call_center_bpo_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Footer Link', 'call-center-bpo' ) . '</h3>',
	'priority'    => 10,
] );

  Kirki::add_field( 'theme_config_id', [
	'type'        => 'switch',
	'settings'    => 'call_center_bpo_copyright_enable',
	'label'       => esc_html__( 'Section Enable / Disable', 'call-center-bpo' ),
	'section'     => 'call_center_bpo_footer_section',
	'default'     => '1',
	'priority'    => 10,
	'choices'     => [
		'on'  => esc_html__( 'Enable', 'call-center-bpo' ),
		'off' => esc_html__( 'Disable', 'call-center-bpo' ),
	],
] );

  Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'call_center_bpo_footer_text_heading',
	'section'     => 'call_center_bpo_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Text', 'call-center-bpo' ) . '</h3>',
	'priority'    => 10,
] );

  Kirki::add_field( 'theme_config_id', [
	'type'     => 'text',
	'settings' => 'call_center_bpo_footer_text',
	'section'  => 'call_center_bpo_footer_section',
	'default'  => '',
	'priority' => 10,
] );

Kirki::add_field( 'theme_config_id', [
'type'        => 'custom',
'settings'    => 'call_center_bpo_footer_text_heading_2',
'section'     => 'call_center_bpo_footer_section',
	'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Alignment', 'call-center-bpo' ) . '</h3>',
'priority'    => 10,
] );

new \Kirki\Field\Select(
[
	'settings'    => 'call_center_bpo_copyright_text_alignment',
	'label'       => esc_html__( 'Copyright text Alignment', 'call-center-bpo' ),
	'section'     => 'call_center_bpo_footer_section',
	'default'     => 'LEFT-ALIGN',
	'placeholder' => esc_html__( 'Choose an option', 'call-center-bpo' ),
	'choices'     => [
		'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'call-center-bpo' ),
		'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'call-center-bpo' ),
		'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'call-center-bpo' ),

	],
] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'call_center_bpo_footer_text_heading_1',
	'section'     => 'call_center_bpo_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Background Color', 'call-center-bpo' ) . '</h3>',
	'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'call_center_bpo_copyright_bg',
		'label'       => __( 'Choose Your Copyright Background Color', 'call-center-bpo' ),
		'section'     => 'call_center_bpo_footer_section',
		'default'     => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'call_center_bpo_enable_footer_socail_link',
		'section'     => 'call_center_bpo_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'call-center-bpo' ) . '</h3>',
		'priority'    => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'call_center_bpo_footer_section',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Footer Social Icon', 'call-center-bpo' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'call-center-bpo' ),
		'settings'     => 'call_center_bpo_footer_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'call-center-bpo' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'call-center-bpo' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'call-center-bpo' ),
				'description' => esc_html__( 'Add the social icon url here.', 'call-center-bpo' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );
}

/*
 *  Customizer Notifications
 */

$call_center_bpo_config_customizer = array(
    'recommended_plugins' => array( 
        'kirki' => array(
            'recommended' => true,
            'description' => sprintf( 
                /* translators: %s: plugin name */
                esc_html__( 'If you want to show all the sections of the FrontPage, please install and activate %s plugin', 'call-center-bpo' ), 
                '<strong>' . esc_html__( 'Kirki Customizer', 'call-center-bpo' ) . '</strong>'
            ),
        ),
    ),
    'call_center_bpo_recommended_actions'       => array(),
    'call_center_bpo_recommended_actions_title' => esc_html__( 'Recommended Actions', 'call-center-bpo' ),
    'call_center_bpo_recommended_plugins_title' => esc_html__( 'Recommended Plugin', 'call-center-bpo' ),
    'call_center_bpo_install_button_label'      => esc_html__( 'Install and Activate', 'call-center-bpo' ),
    'call_center_bpo_activate_button_label'     => esc_html__( 'Activate', 'call-center-bpo' ),
    'call_center_bpo_deactivate_button_label'   => esc_html__( 'Deactivate', 'call-center-bpo' ),
);

Call_Center_Bpo_Customizer_Notify::init( apply_filters( 'call_center_bpo_customizer_notify_array', $call_center_bpo_config_customizer ) );