<?php

class Call_Center_Bpo_Customizer_Notify {

	private $config = array(); // Declare $config property
	
	private $call_center_bpo_recommended_actions;
	
	private $recommended_plugins;
	
	private static $instance;
	
	private $call_center_bpo_recommended_actions_title;
	
	private $call_center_bpo_recommended_plugins_title;
	
	private $dismiss_button;
	
	private $call_center_bpo_install_button_label;
	
	private $call_center_bpo_activate_button_label;
	
	private $call_center_bpo_deactivate_button_label;

	
	public static function init( $config ) {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Call_Center_Bpo_Customizer_Notify ) ) {
			self::$instance = new Call_Center_Bpo_Customizer_Notify;
			if ( ! empty( $config ) && is_array( $config ) ) {
				self::$instance->config = $config;
				self::$instance->setup_config();
				self::$instance->setup_actions();
			}
		}

	}

	
	public function setup_config() {

		global $call_center_bpo_customizer_notify_recommended_plugins;
		global $call_center_bpo_customizer_notify_call_center_bpo_recommended_actions;

		global $call_center_bpo_install_button_label;
		global $call_center_bpo_activate_button_label;
		global $call_center_bpo_deactivate_button_label;

		$this->call_center_bpo_recommended_actions = isset( $this->config['call_center_bpo_recommended_actions'] ) ? $this->config['call_center_bpo_recommended_actions'] : array();
		$this->recommended_plugins = isset( $this->config['recommended_plugins'] ) ? $this->config['recommended_plugins'] : array();

		$this->call_center_bpo_recommended_actions_title = isset( $this->config['call_center_bpo_recommended_actions_title'] ) ? $this->config['call_center_bpo_recommended_actions_title'] : '';
		$this->call_center_bpo_recommended_plugins_title = isset( $this->config['call_center_bpo_recommended_plugins_title'] ) ? $this->config['call_center_bpo_recommended_plugins_title'] : '';
		$this->dismiss_button            = isset( $this->config['dismiss_button'] ) ? $this->config['dismiss_button'] : '';

		$call_center_bpo_customizer_notify_recommended_plugins = array();
		$call_center_bpo_customizer_notify_call_center_bpo_recommended_actions = array();

		if ( isset( $this->recommended_plugins ) ) {
			$call_center_bpo_customizer_notify_recommended_plugins = $this->recommended_plugins;
		}

		if ( isset( $this->call_center_bpo_recommended_actions ) ) {
			$call_center_bpo_customizer_notify_call_center_bpo_recommended_actions = $this->call_center_bpo_recommended_actions;
		}

		$call_center_bpo_install_button_label    = isset( $this->config['call_center_bpo_install_button_label'] ) ? $this->config['call_center_bpo_install_button_label'] : '';
		$call_center_bpo_activate_button_label   = isset( $this->config['call_center_bpo_activate_button_label'] ) ? $this->config['call_center_bpo_activate_button_label'] : '';
		$call_center_bpo_deactivate_button_label = isset( $this->config['call_center_bpo_deactivate_button_label'] ) ? $this->config['call_center_bpo_deactivate_button_label'] : '';

	}

	
	public function setup_actions() {

		// Register the section
		add_action( 'customize_register', array( $this, 'call_center_bpo_plugin_notification_customize_register' ) );

		// Enqueue scripts and styles
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'call_center_bpo_customizer_notify_scripts_for_customizer' ), 0 );

		/* ajax callback for dismissable recommended actions */
		add_action( 'wp_ajax_quality_customizer_notify_dismiss_action', array( $this, 'call_center_bpo_customizer_notify_dismiss_recommended_action_callback' ) );

		add_action( 'wp_ajax_ti_customizer_notify_dismiss_recommended_plugins', array( $this, 'call_center_bpo_customizer_notify_dismiss_recommended_plugins_callback' ) );

	}

	
	public function call_center_bpo_customizer_notify_scripts_for_customizer() {

		wp_enqueue_style( 'call-center-bpo-customizer-notify-css', get_template_directory_uri() . '/core/includes/customizer-notice/css/call-center-bpo-customizer-notify.css', array());

		wp_enqueue_style( 'plugin-install' );
		wp_enqueue_script( 'plugin-install' );
		wp_add_inline_script( 'plugin-install', 'var pagenow = "customizer";' );

		wp_enqueue_script( 'updates' );

		wp_enqueue_script( 'call-center-bpo-customizer-notify-js', get_template_directory_uri() . '/core/includes/customizer-notice/js/call-center-bpo-customizer-notify.js', array( 'customize-controls' ));
		wp_localize_script(
			'call-center-bpo-customizer-notify-js', 'callcenterbpoCustomizercompanionObject', array(
				'ajaxurl'            => admin_url( 'admin-ajax.php' ),
				'template_directory' => get_template_directory_uri(),
				'base_path'          => admin_url(),
				'activating_string'  => __( 'Activating', 'call-center-bpo' ),
			)
		);

	}

	
	public function call_center_bpo_plugin_notification_customize_register( $wp_customize ) {

		
		require_once get_template_directory() . '/core/includes/customizer-notice/call-center-bpo-customizer-notify-section.php';

		$wp_customize->register_section_type( 'Call_Center_Bpo_Customizer_Notify_Section' );

		$wp_customize->add_section(
			new Call_Center_Bpo_Customizer_Notify_Section(
				$wp_customize,
				'call-center-bpo-customizer-notify-section',
				array(
					'title'          => $this->call_center_bpo_recommended_actions_title,
					'plugin_text'    => $this->call_center_bpo_recommended_plugins_title,
					'dismiss_button' => $this->dismiss_button,
					'priority'       => 0,
				)
			)
		);

	}

	
	public function call_center_bpo_customizer_notify_dismiss_recommended_action_callback() {

		global $call_center_bpo_customizer_notify_call_center_bpo_recommended_actions;

		$action_id = ( isset( $_GET['id'] ) ) ? $_GET['id'] : 0;

		echo esc_html( $action_id ); /* this is needed and it's the id of the dismissable required action */ 

		if ( ! empty( $action_id ) ) {
			
			if ( get_option( 'call_center_bpo_customizer_notify_show' ) ) {

				$call_center_bpo_customizer_notify_show_call_center_bpo_recommended_actions = get_option( 'call_center_bpo_customizer_notify_show' );
				switch ( $_GET['todo'] ) {
					case 'add':
						$call_center_bpo_customizer_notify_show_call_center_bpo_recommended_actions[ $action_id ] = true;
						break;
					case 'dismiss':
						$call_center_bpo_customizer_notify_show_call_center_bpo_recommended_actions[ $action_id ] = false;
						break;
				}
				update_option( 'call_center_bpo_customizer_notify_show', $call_center_bpo_customizer_notify_show_call_center_bpo_recommended_actions );

				
			} else {
				$call_center_bpo_customizer_notify_show_call_center_bpo_recommended_actions = array();
				if ( ! empty( $call_center_bpo_customizer_notify_call_center_bpo_recommended_actions ) ) {
					foreach ( $call_center_bpo_customizer_notify_call_center_bpo_recommended_actions as $call_center_bpo_lite_customizer_notify_recommended_action ) {
						if ( $call_center_bpo_lite_customizer_notify_recommended_action['id'] == $action_id ) {
							$call_center_bpo_customizer_notify_show_call_center_bpo_recommended_actions[ $call_center_bpo_lite_customizer_notify_recommended_action['id'] ] = false;
						} else {
							$call_center_bpo_customizer_notify_show_call_center_bpo_recommended_actions[ $call_center_bpo_lite_customizer_notify_recommended_action['id'] ] = true;
						}
					}
					update_option( 'call_center_bpo_customizer_notify_show', $call_center_bpo_customizer_notify_show_call_center_bpo_recommended_actions );
				}
			}
		}
		die(); 
	}

	
	public function call_center_bpo_customizer_notify_dismiss_recommended_plugins_callback() {

		$action_id = ( isset( $_GET['id'] ) ) ? $_GET['id'] : 0;

		echo esc_html( $action_id ); /* this is needed and it's the id of the dismissable required action */

		if ( ! empty( $action_id ) ) {

			$call_center_bpo_lite_customizer_notify_show_recommended_plugins = get_option( 'call_center_bpo_customizer_notify_show_recommended_plugins' );

			switch ( $_GET['todo'] ) {
				case 'add':
					$call_center_bpo_lite_customizer_notify_show_recommended_plugins[ $action_id ] = false;
					break;
				case 'dismiss':
					$call_center_bpo_lite_customizer_notify_show_recommended_plugins[ $action_id ] = true;
					break;
			}
			update_option( 'call_center_bpo_customizer_notify_show_recommended_plugins', $call_center_bpo_lite_customizer_notify_show_recommended_plugins );
		}
		die(); 
	}

}
